<?php

namespace App\Http\Controllers\Web;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Modals\Menu;
use App\Modals\Brand;
use App\Modals\Submenu;
use App\Modals\Color;
use App\Modals\Size;
use App\Modals\Product;
use App\Modals\Main;
use App\Modals\Box;
use App\Modals\Secbox;
use App\Modals\Addbox;
use App\Modals\Contact;
use App\Modals\Order;
use App\Modals\Newspaper;
use App\Modals\Orderitem;
use App\Mail\Registration;
use App\Mail\ProductBooking;
use Session;
use App\User;
use Hash;
use Mail;
use Auth;

class WebController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {

      $menus = Menu::all();
      $brands = Brand::all();
      $main = Main::first();
      $box = Box::first();
      $secbox = Secbox::first();
      $addbox = Addbox::first();
      $products = Product::all();
      return view('web.index', ['menus'=>$menus,'brands'=>$brands,'main'=>$main,'box'=>$box,'secbox'=>$secbox,'addbox'=>$addbox,'products'=>$products]);
    }
    public function itemLists($type,$id)
    {
      if(!isset($type) && $type == null && !isset($id) && $id == null)
      {
        return redirect()->route('main');
      }

      if($type == "brand")
      {
        $products = Product::where('brand_id', $id)->get();
        $txt = Brand::where('id', $id)->first();
      }
      if($type == "submenu")
      {
        $products = Product::where('submenu_id', $id)->get();
        $txt = Submenu::where('id', $id)->first();
      }
      if($type == "menu")
      {
        $products = Product::where('menu_id', $id)->get();
        $txt = Menu::where('id', $id)->first();
      }


      $menus = Menu::all();
      $submenus = Menu::all();
      $brands = Brand::all();
      $type = $type;
      return view('web.itemLists', ['menus'=>$menus,'brands'=>$brands,'submenus'=>$submenus,'type'=>$type,'products'=>$products,'txt'=>$txt,'type_id'=>$id]);
    }



    public function itemList(Request $request)
    {

      $type = $request->type;
      $id = $request->id;
      if(!isset($type) && $type == null && !isset($id) && $id == null)
      {
        return redirect()->route('main');
      }

      if($type == "brand")
      {
        $products = Product::where('brand_id', $id)->get();
        $txt = Brand::where('id', $id)->first();
      }
      if($type == "submenu")
      {
        $products = Product::where('submenu_id', $id)->get();
        $txt = Submenu::where('id', $id)->first();
      }
      if($type == "menu")
      {
        $products = Product::where('menu_id', $id)->get();
        $txt = Menu::where('id', $id)->first();
      }

      $products = $products->where('price', '>', $request->min);
      $products = $products->where('price', '<', $request->max);


      $menus = Menu::all();
      $submenus = Submenu::all();
      $brands = Brand::all();
      $type = $type;
      return view('web.itemLists', ['menus'=>$menus,'brands'=>$brands,'submenus'=>$submenus,'type'=>$type,'products'=>$products,'txt'=>$txt,'type_id'=>$id]);
    }



    public function itemDetail($id)
    {
      if(!isset($id) && $id == null)
      {
        return redirect()->route('main');
      }
      $menus = Menu::all();
      $brands = Brand::all();
      $product = Product::where('id', $id)->first();
      return view('web.itemDetail', ['menus'=>$menus,'brands'=>$brands,'product'=>$product]);
    }

    public function contact()
    {
      $menus = Menu::all();
      $brands = Brand::all();
        return view('web.contact', ['menus'=>$menus,'brands'=>$brands]);
    }

    public function reg()
    {
      $menus = Menu::all();
      $brands = Brand::all();
        return view('web.reg', ['menus'=>$menus,'brands'=>$brands]);
    }

    public function news()
    {
      $menus = Menu::all();
      $brands = Brand::all();
        $news = Newspaper::all();
        return view('web.news', ['menus'=>$menus,'brands'=>$brands,'news'=>$news]);
    }

    public function about()
    {
      $menus = Menu::all();
      $brands = Brand::all();
        return view('web.about', ['menus'=>$menus,'brands'=>$brands]);
    }


    public function submitcontact(Request $request)
    {
      $contact = new Contact();
      $contact->name = $request->name;
      $contact->contact = $request->contact;
      $contact->email = $request->email;
      $contact->message = $request->message;
      $contact->save() ;

      Session::flash('success', 'Thanks you for reaching us, Our team will contact you soon !');
        return redirect()->back();
    }

    public function submitreg(Request $request)
    {

      $data = $request->input();
      Mail::to("PakHempTraders@gmail.com")->send(new Registration($data));

      Session::flash('success', 'Thanks you for reaching us, Our team will contact you soon !');
        return redirect()->back();
    }

    public function booknow(Request $request)
    {

      $data = $request->input();
      Mail::to("PakHempTraders@gmail.com")->send(new ProductBooking($data));

      Session::flash('success', 'Thanks you for booking product, Our team will contact you soon !');
        return redirect()->back();
    }



    public function addToCart($id)
    {
      $product = Product::find($id);
        if(!$product) {
            abort(404);
        }

        $cart = session()->get('cart');

        // if cart is empty then this the first product
        if(!$cart) {
            $cart = [
                    $id => [
                      "id" => $product->id,
                        "name" => $product->name,
                        "quantity" => 1,
                        "price" => $product->price,
                        "photo" => $product->image1,
                        "notes" => "",
                        "actual_price" => $product->actual_price,
                    ]
            ];
            session()->put('cart', $cart);
            return redirect()->back()->with('success', 'Product added to cart successfully!');
        }
        // if cart not empty then check if this product exist then increment quantity
        if(isset($cart[$id])) {

            $cart[$id]['quantity']++;
            session()->put('cart', $cart);
            Session::flash('success', 'Product added to cart successfully!');
            return redirect()->back();
        }

        else{

        // if item not exist in cart then add to cart with quantity = 1
        $cart[$id] = [
          "id" => $product->id,
            "name" => $product->name,
            "quantity" => 1,
            "price" => $product->price,
            "photo" => $product->image1,
            "notes" => "",
            "actual_price" => $product->actual_price,
        ];
        session()->put('cart', $cart);

        Session::flash('success', 'Product added to cart successfully!');
          return redirect()->back();
        }

    }

    public function substractquantity($id)
    {

            $cart = session()->get('cart');
            $cart[$id]["quantity"] = $cart[$id]["quantity"]-1;
            session()->put('cart', $cart);
            session()->flash('success', 'Cart updated successfully');
        return redirect()->route('cart');
    }



    public function removeitem($id)
    {
            $cart = session()->get('cart');
            if(isset($cart[$id])) {
                unset($cart[$id]);
                session()->put('cart', $cart);

            session()->flash('success', 'Product removed successfully');
            return redirect()->route('cart');
            }
        return redirect()->route('cart');
    }


    public function removeall()
    {
            $cart = session()->forget('cart');

        return redirect()->route('cart');
    }


    public function cart()
    {
      $menus = Menu::all();
      $brands = Brand::all();
      return view('web.cart', ['menus'=>$menus,'brands'=>$brands]);
    }
    public function checkout()
    {
      $menus = Menu::all();
      $brands = Brand::all();
      return view('web.checkout', ['menus'=>$menus,'brands'=>$brands]);
    }

    public function submitcheckout(Request $request)
    {
      $order = new Order();
      $order->name = $request->name;
      $order->contact = $request->contact;
      $order->email = $request->email;
      $order->address = $request->address;
      $order->city = $request->city;
      $order->amount = $request->amount;
      $order->notes = $request->notes;
      $order->payment = $request->payment;
      $order->save();

      $cart = session()->get('cart');
      foreach($cart as $id => $details)
      {
        $orderitem = new Orderitem();
        $orderitem->product_id = $details['id'];
        $orderitem->amount = $details['quantity'] * $details['price'];
        $orderitem->qty = $details['quantity'];
        $orderitem->order_id = $order->id;
        $orderitem->save();
      }
      $norder = Order::where('id', $order->id)->first();
      $norder->order_no = "MK-".$order->id;
      $norder->save();

      $order_no = $norder->order_no;

      session()->forget('cart');
      session()->flash('success', 'order placed');
      return redirect()->route('thanks',$order_no);
    }

    public function thanks($id)
    {

      if(!isset($id))
      {
        return redirect()->route('main');
      }

      $order = Order::where('order_no', $id)->first();

      if(!isset($order->id))
      {
        return redirect()->route('main');
      }

      $menus = Menu::all();
      $brands = Brand::all();
      return view('web.thanks', ['menus'=>$menus,'brands'=>$brands,'order'=>$order]);
    }



}
