@extends('layouts.admin')



@section('styles')

@endsection



@section('content')

<!-- ============================================================== -->

<!-- Start right Content here -->

<!-- ============================================================== -->

<div class="content-page">

    <!-- Start content -->

    <div class="content">

        <div class="container-fluid">



            <div class="row">

                <div class="col-sm-12">

                    <div class="page-title-box">

                        <div class="row align-items-center">

                            <div class="col-md-8">

                                <h4 class="page-title mb-0">Welcome to your Dashboard</h4>



                            </div>



                        </div>



                    </div>

                </div>

            </div>

            <!-- end row -->



            <div class="row">

                <div class="col-xl-4 col-md-6">

                    <div class="card mini-stats">

                        <div class="p-3 mini-stats-content">



                        </div>

                        <div class="ml-3 mr-3">

                            <div class="bg-white p-3 mini-stats-desc rounded">

                                <h4 class="float-right mt-1 text-success">{{$totalorder}} </h4>

                                <h5 class="mt-1 mb-1">Total Orders</h5>



                            </div>

                        </div>

                    </div>

                </div>

                <div class="col-xl-4 col-md-6">

                    <div class="card mini-stats">

                        <div class="p-3 mini-stats-content">



                        </div>

                        <div class="ml-3 mr-3">

                            <div class="bg-white p-3 mini-stats-desc rounded">

                                <h4 class="float-right mt-1 text-info">{{$neworder}} </h4>

                                <h5 class="mt-1 mb-1">New</h5>


                            </div>

                        </div>

                    </div>

                </div>

                <div class="col-xl-4 col-md-6">

                    <div class="card mini-stats">

                        <div class="p-3 mini-stats-content">



                        </div>

                        <div class="ml-3 mr-3">

                            <div class="bg-white p-3 mini-stats-desc rounded">

                                <h4 class="float-right mt-1 text-danger"> {{$inprocessorder}}</h4>

                                <h5 class="mt-1 mb-1">Inprocess</h5>



                            </div>

                        </div>

                    </div>

                </div>



                <div class="col-xl-4 col-md-6">

                    <div class="card mini-stats">

                        <div class="p-3 mini-stats-content">



                        </div>

                        <div class="ml-3 mr-3">

                            <div class="bg-white p-3 mini-stats-desc rounded">

                                <h4 class="float-right mt-1 text-danger"> {{$deliveredorder}}</h4>

                                <h5 class="mt-1 mb-1">Delivered Orders</h5>



                            </div>

                        </div>

                    </div>

                </div>


                <div class="col-xl-4 col-md-6">

                    <div class="card mini-stats">

                        <div class="p-3 mini-stats-content">



                        </div>

                        <div class="ml-3 mr-3">

                            <div class="bg-white p-3 mini-stats-desc rounded">

                                <h4 class="float-right mt-1 text-danger"> {{$todayorder}}</h4>

                                <h5 class="mt-1 mb-1">Total Today's Orders</h5>



                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <!-- end row -->

            <div class="row">
                                      <div class="col-xl-12">
                                          <div class="card">
                                              <div class="card-body">
                                                  <h4 class="mt-0 header-title mb-5">Product wise sale</h4>
                                                  <div id="morris-bar-stacked" class="morris-chart-height morris-charts"></div>
                                              </div>
                                          </div>
                                      </div>


                            <div class="col-xl-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="mt-0 header-title">Payment Details</h4>

                                        <div class="row text-center m-t-20">

                                            <!-- <div class="col-3">
                                                <h5 class="">8</h5>
                                                <p class="text-muted font-14">Grade 10</p>
                                            </div>
											 <div class="col-3">
                                                <h5 class="">864</h5>
                                                <p class="text-muted font-14">Grade 11</p>
                                            </div>
											 <div class="col-3">
                                                <h5 class="">843</h5>
                                                <p class="text-muted font-14">Grade 12</p>
                                            </div> -->
                                        </div>

                                        <div id="morris-donut-example" class="dash-chart morris-charts text-center"></div>
                                    </div>
                                </div>

                            </div>
                        </div>

<div class="row">

  <div class="col-md-12">


  </div>


</div>





        </div> <!-- container-fluid -->



    </div> <!-- content -->



    <footer class="footer">

        © 2020 - 2021  Mommy Kloset

    </footer>

</div>





<!-- ============================================================== -->

<!-- End Right content here -->

<!-- ============================================================== -->



@endsection



@section('scripts')
<script>
/*

 File: Dashboard js
 */

!function ($) {
    "use strict";

    var Dashboard = function () {
    };

        //creates Stacked chart
        Dashboard.prototype.createStackedChart  = function(element, data, xkey, ykeys, labels, lineColors) {
            Morris.Bar({
                element: element,
                data: data,
                xkey: xkey,
                ykeys: ykeys,
                stacked: true,
                labels: labels,
                hideHover: 'auto',
                resize: true, //defaulted to true
                gridLineColor: '#eeeeee',
                barColors: lineColors
            });
        },

        //creates Donut chart
        Dashboard.prototype.createDonutChart = function (element, data, colors) {
            Morris.Donut({
                element: element,
                data: data,
                resize: true,
                colors: colors,
            });
        },

        // pie
        $('.peity-pie').each(function () {
            $(this).peity("pie", $(this).data());
        });

        //donut
        $('.peity-donut').each(function () {
            $(this).peity("donut", $(this).data());
        });

        // line
        $('.peity-line').each(function () {
            $(this).peity("line", $(this).data());
        });


        Dashboard.prototype.init = function () {

            //creating Stacked chart
            var $stckedData  = [
              @foreach($products as $p)
              @php $pc = App\Modals\Orderitem::where('product_id', $p->id)->sum('qty');  @endphp
                {y: "{{$p->name}}", a: "{{$pc}}"},
                @endforeach


            ];
            this.createStackedChart('morris-bar-stacked', $stckedData, 'y', ['a'], ['Sale'], ['#655be6']);


            //creating donut chart
            var $donutData = [

                {label: "Total", value: "{{$gtotal}}"},
                  {label: "Pending", value: "{{$totalpending}}"},
                    {label: "Received", value: "{{$totalreceived}}"},

            ];
            this.createDonutChart('morris-donut-example', $donutData, ['#46cd93', '#655be6', '#1699dd', '#fdba45']);


        },
        //init
        $.Dashboard = new Dashboard, $.Dashboard.Constructor = Dashboard
}(window.jQuery),

//initializing
    function ($) {
        "use strict";
        $.Dashboard.init();
    }(window.jQuery);


</script>

@endsection
