<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Modals\Booking;
use App\Modals\Slider;
use App\Modals\About;
use App\Modals\Gallery;
use App\Modals\Comment;
use Session;
use App\User;
use Carbon\Carbon;
use Hash;
use Auth;


class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
         $this->middleware('auth');
         $this->middleware('adminuser');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function dashboard()
    {
      $booking = Booking::where('status', 0)->get();

      $totalbooking = Booking::count();

      $approved = Booking::where('status', 1)->count();

      $new = Booking::where('status', 0)->count();
        return view('admin.dashboard', ['booking'=>$booking,'totalbooking'=>$totalbooking,'approved'=>$approved,'new'=>$new]);
    }

    public function sliders()
    {
        $slider = Slider::all();
        return view('admin.slider', ['slider'=>$slider]);
    }


    public function comments()
    {
        $slider = Comment::all();
        return view('admin.comment', ['comments'=>$slider]);
    }


    public function addcomment(Request $request)
    {
        $comment = new Comment();
        $comment->name = $request->name;
        $comment->description = $request->description;
        $comment->save();
        Session::flash('success', 'Successfully, added !');
        return redirect()->back();
    }


    public function abouts()
    {
        $about = About::first();
        return view('admin.about', ['about'=>$about]);
    }

    public function video()
    {
        $about = About::first();
        return view('admin.video', ['about'=>$about]);
    }

    public function bookings()
    {
        $booking = Booking::all();
        return view('admin.booking', ['booking'=>$booking]);
    }

    public function gallery()
    {
        $gallery = Gallery::all();
        return view('admin.gallery', ['gallery'=>$gallery]);
    }

    public function deleteslider($id)
    {

      $count = Slider::count();
      if($count == 1)
      {
        Session::flash('error', 'you can only delete min 1 sliders at a time should be there please add one and then delete');
        return redirect()->back();
      }

        $slider = Slider::where('id',$id)->first();
        $slider->delete();
        Session::flash('success', 'Successfully, Deleted !');
        return redirect()->back();
    }

    public function deletegallery($id)
    {
        $gallery = Gallery::where('id',$id)->first();
        $gallery->delete();
        Session::flash('success', 'Successfully, Deleted !');
        return redirect()->back();
    }


    public function deletecomments($id)
    {
        $gallery = Comment::where('id',$id)->first();
        $gallery->delete();
        Session::flash('success', 'Successfully, Deleted !');
        return redirect()->back();
    }

    public function addgallery(Request $request)
    {


        $gallery = new Gallery();

        if($request->image)
        {
        $value = $request->image;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $gallery->image =  $namefile;
        }

        $gallery->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }

    public function addsliders(Request $request)
    {

        $count = Slider::count();

        if($count == 3)
        {
          Session::flash('error', 'you can only add max 3 sliders at a time');
          return redirect()->back();
        }
        $main = new Slider();
        $main->h1 = $request->h1;
        $main->h2 = $request->h2;

        if($request->image)
        {
        $value = $request->image;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $main->image =  $namefile;
        }

        $main->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }



        public function editvideo(Request $request)
        {


            $about = About::first();
            $about->link = $request->link;


            $about->save();

            Session::flash('success', 'Successfully, Added !');
            return redirect()->back();
        }


    public function editabout(Request $request)
    {


        $about = About::first();
        $about->h1 = $request->formsummernote2;
        $about->h2 = $request->formsummernote;
        $about->h3 = $request->formsummernote3;

        if($request->image1)
        {
        $value = $request->image1;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $about->image1 =  $namefile;
        }

        if($request->image2)
        {
        $value = $request->image2;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $about->image2 =  $namefile;
        }

        $about->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }



    public function getboxes()
    {
        $box = Box::first();

        return view('admin.boxes', ['box'=>$box]);
    }


    public function contacts()
    {
        $contacts = Contact::all();

        return view('admin.contacts', ['contacts'=>$contacts]);
    }


    public function discardcontacts($id)
    {
        $contacts = Contact::where('id', $id)->first();
        $contacts->status = 1;
        $contacts->save();
        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }


    public function editboxes(Request $request)
    {
        $box = Box::first();
        $box->ah1 = $request->ah1;
        $box->ah2 = $request->ah2;
        $box->bh1 = $request->bh1;
        $box->bh2 = $request->bh2;
        $box->ch1 = $request->ch1;
        $box->ch2 = $request->ch2;

        if($request->image1)
        {
        $value = $request->image1;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image1 =  $namefile;
        }

        if($request->image2)
        {
        $value = $request->image2;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image2 =  $namefile;
        }

        if($request->image3)
        {
        $value = $request->image3;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image3 =  $namefile;
        }

        $box->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }



    public function getsecboxes()
    {
        $box = Secbox::first();

        return view('admin.secboxes', ['box'=>$box]);
    }


    public function editsecboxes(Request $request)
    {
        $box = Secbox::first();
        $box->ah1 = $request->ah1;
        $box->ah2 = $request->ah2;
        $box->bh1 = $request->bh1;
        $box->bh2 = $request->bh2;


        if($request->image1)
        {
        $value = $request->image1;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image1 =  $namefile;
        }

        if($request->image2)
        {
        $value = $request->image2;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image2 =  $namefile;
        }


        $box->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }


    public function getaddboxes()
    {
        $box = Addbox::first();

        return view('admin.addboxes', ['box'=>$box]);
    }


    public function editaddboxes(Request $request)
    {
        $box = addbox::first();
        $box->h1 = $request->h1;
        $box->h2 = $request->h2;
        $box->h3 = $request->h3;
        $box->h4 = $request->h4;


        if($request->image)
        {
        $value = $request->image;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image =  $namefile;
        }



        $box->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }

    public function addbrands(Request $request)
    {
        $brands = new Brand();
        $brands->name = $request->name;
        $brands->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }


    public function editbrands(Request $request)
    {
        $brands = Brand::where('id',$request->brand_id)->first();
        $brands->name = $request->name;
        $brands->save();

        Session::flash('success', 'Successfully, Edited !');
        return redirect()->back();
    }


    public function editmenus(Request $request)
    {
        $brands = Menu::where('id',$request->menu_id)->first();
        $brands->name = $request->name;
        $brands->save();

        Session::flash('success', 'Successfully, Edited !');
        return redirect()->back();
    }

    public function editsubmenus(Request $request)
    {
        $brands = Submenu::where('id',$request->submenu_id)->first();
        $brands->name = $request->name;
          $brands->menu_id = $request->menu_id;
        $brands->save();

        Session::flash('success', 'Successfully, Edited !');
        return redirect()->back();
    }


    public function showproducts($id)
    {
        $product = Product::where('id',$id)->first();
        $submenus = Submenu::all();
          $brands = Brand::all();

        return view('admin.showproducts', ['submenus'=>$submenus,'product'=>$product,'brands'=>$brands]);
    }
    public function addmenus(Request $request)
    {
        $menus = new Menu();
        $menus->name = $request->name;
        $menus->save();


        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }

    public function addsubmenus(Request $request)
    {
        $submenus = new Submenu();
        $submenus->name = $request->name;
        $submenus->menu_id = $request->menu_id;
        $submenus->save();


        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }


    public function addproducts(Request $request)
    {
      $mm = Submenu::where('id', $request->menu_id)->first();

        $product = new Product();
        $product->name = $request->name;
        $product->details = $request->details;
        $product->description = $request->description;
        $product->brand_id = $request->brand_id;
        $product->menu_id = $mm->menu_id;
        $product->submenu_id = $request->menu_id;
        $product->price = $request->price;
        $product->actual_price = $request->actual_price;
        $product->sale = $request->sale;
        $product->stock = $request->stock;


        if($request->image1)
        {
        $value = $request->image1;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image1 =  $namefile;
        }

        if($request->image2)
        {
        $value = $request->image2;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image2 =  $namefile;
        }

        if($request->image3)
        {
        $value = $request->image3;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image3 =  $namefile;
        }

        if($request->image4)
        {
        $value = $request->image4;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image4 =  $namefile;
        }

        $product->save();

        // $myArray = explode(',', $request->colors);
        // foreach($myArray as $ma)
        // {
        // $color = new Color();
        // $color->product_id = $product->id;
        // $color->name = $ma;
        // $color->save();
        // }
        //
        // $myArray1 = explode(',', $request->sizes);
        // foreach($myArray1 as $ma1)
        // {
        // $size = new Size();
        // $size->product_id = $product->id;
        // $size->name = $ma1;
        // $size->save();
        // }


        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }



    public function editproducts(Request $request)
    {
      $mm = Submenu::where('id', $request->menu_id)->first();

        $product = Product::where('id',$request->product_id)->first();
        $product->name = $request->name;
        $product->details = $request->details;
        $product->description = $request->description;
        $product->brand_id = $request->brand_id;
        $product->menu_id = $mm->menu_id;
        $product->submenu_id = $request->menu_id;
        $product->price = $request->price;
        $product->actual_price = $request->actual_price;
        $product->sale = $request->sale;
        $product->stock = $request->stock;


        if($request->image1)
        {
        $value = $request->image1;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image1 =  $namefile;
        }

        if($request->image2)
        {
        $value = $request->image2;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image2 =  $namefile;
        }

        if($request->image3)
        {
        $value = $request->image3;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image3 =  $namefile;
        }

        if($request->image4)
        {
        $value = $request->image4;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image4 =  $namefile;
        }

        $product->save();

        // $myArray = explode(',', $request->colors);
        // foreach($myArray as $ma)
        // {
        // $color = new Color();
        // $color->product_id = $product->id;
        // $color->name = $ma;
        // $color->save();
        // }
        //
        // $myArray1 = explode(',', $request->sizes);
        // foreach($myArray1 as $ma1)
        // {
        // $size = new Size();
        // $size->product_id = $product->id;
        // $size->name = $ma1;
        // $size->save();
        // }


        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }

    public function neworders()
    {
      $orders =  Order::where('status' , 0)->get();

      return view('admin.neworders' , ['orders'=>$orders]);
    }

    public function inprocessorders()
    {
      $orders =  Order::where('status' , 1)->get();

      return view('admin.neworders' , ['orders'=>$orders]);
    }

    public function deliveredorders()
    {
      $orders =  Order::where('status' , 2)->get();

      return view('admin.neworders' , ['orders'=>$orders]);
    }


    public function orderdetails($id)
    {
      $order =  Order::where('id' , $id)->first();

      return view('admin.showorder' , ['order'=>$order]);
    }

    public function changestatus($id,$val)
    {
      $booking =  Booking::where('id' , $id)->first();

      $booking->status = $val;
      $booking->save();

      Session::flash('success', 'Successfully, changed !');
      return redirect()->back();
    }


    public function deleteproducts($id)
    {
      $order =  Product::where('id' , $id)->first();


      $order->delete();

      Session::flash('success', 'Successfully, deleted !');
      return redirect()->back();
    }


    public function deletemenu($id)
    {
      $order =  Menu::where('id' , $id)->first();


      $order->delete();

      Session::flash('success', 'Successfully, deleted !');
      return redirect()->back();
    }

    public function deletesubmenu($id)
    {
      $order =  Submenu::where('id' , $id)->first();


      $order->delete();

      Session::flash('success', 'Successfully, deleted !');
      return redirect()->back();
    }


    public function deletebrand($id)
    {
      $order =  Brand::where('id' , $id)->first();


      $order->delete();

      Session::flash('success', 'Successfully, deleted !');
      return redirect()->back();
    }


    public function changepass(Request $request)
    {
      $user =  User::first();
      $user->password = Hash::make($request->name);

      $user->save();

      Session::flash('success', 'Successfully, changed !');
      return redirect()->back();
    }
}
