<?php

namespace App\Http\Controllers\Web;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Modals\Booking;
use App\Modals\Slider;
use App\Modals\About;
use App\Modals\Gallery;
use App\Modals\Comment;
use Session;
use App\User;
use Hash;
use Auth;

class WebController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
      $sliders = Slider::get();
      $gallery = Gallery::get()->take(8);
      $about = About::first();
      $comments = Comment::all();
      return view('web.index',['sliders'=>$sliders,'gallery'=>$gallery,'about'=>$about,'comments'=>$comments]);
    }


    public function booking(Request $request)
    {
      return view('web.booking');
    }



    public function services()
    {

        return view('web.services');
    }

    public function about()
    {
      $about = About::first();
        return view('web.about',['about'=>$about]);
    }

    public function gallery()
    {
        $gallery = Gallery::get();
        return view('web.gallery',['gallery'=>$gallery]);
    }


    public function submitcontact(Request $request)
    {
      $contact = new Contact();
      $contact->name = $request->name;
      $contact->contact = $request->contact;
      $contact->email = $request->email;
      $contact->message = $request->message;
      $contact->save() ;

      Session::flash('success', 'Thanks you for reaching us, Our team will contact you soon !');
        return redirect()->back();
    }



    public function submitbooking(Request $request)
    {
      $booking = new Booking();
      $booking->first_name = $request->first_name;
      $booking->last_name = $request->last_name;
      $booking->email = $request->email;
      $booking->phone = $request->phone;
      $booking->in_date = $request->in_date;
      $booking->in_time = $request->in_time;
      $booking->out_date = $request->out_date;
      $booking->out_time = $request->out_time;
      $booking->number = $request->number;
      $booking->child = $request->child;
      $booking->save();

      $nbooking = Booking::where('id', $booking->id)->first();
      $nbooking->booking_no = "BK-".$booking->id."-".$booking->in_date;
      $nbooking->save();

      $booking_no = $nbooking->booking_no;

      session()->forget('cart');
      session()->flash('success', 'Reservation has been placed');
      return redirect()->route('thanks',$booking_no);
    }

    public function thanks($id)
    {
      if(!isset($id))
      {
        return redirect()->route('main');
      }

      $booking = Booking::where('booking_no', $id)->first();

      if(!isset($booking->id))
      {
        return redirect()->route('main');
      }
      return view('web.thanks', ['booking'=>$booking]);
    }



}
