@extends('layouts.admin')



@section('styles')

@endsection



@section('content')
<!-- start page container -->
<div class="page-container">
@include('includes.sidebar')
  <!-- end sidebar menu -->
  <!-- start page content -->
  <div class="page-content-wrapper">
    <div class="page-content">
      <div class="page-bar">
        <div class="page-title-breadcrumb">
          <div class=" pull-left">
            <div class="page-title">Booking Quries</div>
          </div>
          <ol class="breadcrumb page-breadcrumb pull-right">
            <li><i class="fa fa-home"></i>&nbsp;<a class="parent-item"
                href="index.html">Home</a>&nbsp;<i class="fa fa-angle-right"></i>
            </li>
            <li><a class="parent-item" href="#">Apps</a>&nbsp;<i class="fa fa-angle-right"></i>
            </li>
            <li class="active">Booking Quries</li>
          </ol>
        </div>
      </div>
      <div class="row">
        <div class="col-sm-12">
          <div class="card-box">
            <div class="card-head">
              <header>Booking Quries</header>
            </div>
            <div class="card-body ">
              <div class="state-overview">
              </div>

              <table class="table table-hover table-checkable order-column full-width"
                id="example4">
                <thead>
                  <tr>
                    <th>Sr #</th>
                    <th>Booking #</th>
                    <th>Booking From</th>
                    <th>No of People</th>
                    <th>Checkin Date+Time</th>
                    <th>Checkout Date+Time</th>
                    <th>Contact no</th>
                    <th>Status</th>
                    <th>Email</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($booking as $book)
                  <tr>
                    <td>{{$loop->iteration}}</td>
                    <td>{{$book->booking_no}}</td>
                    <td>{{$book->first_name}} {{$book->last_name}}</td>
                    <td>{{$book->number}} People</td>
                    <td>{{$book->in_date}} {{$book->in_time}}</td>
                    <td>{{$book->out_date}} {{$book->out_time}}</td>
                    <td>{{$book->phone}}</td>
                    <td>
                      @if($book->status == 0)
                      <span class="label label-sm label-success">Reserved/Inprocess</span>
                      @elseif($book->status == 1)
                      <span class="label label-sm label-success">Confirmed</span>
                      @elseif($book->status == 2)
                      <span class="label label-sm label-success">CheckedIn</span>
                      @elseif($book->status == 3)
                      <span class="label label-sm label-success">CheckOut</span>
                      @elseif($book->status == 4)
                      <span class="label label-sm label-success">Canceled</span>
                      @endif
                    </td>
                    <td>{{$book->email}}</td>


                    <td>
                      <div class="btn-group">
                        <button data-toggle="dropdown" class="btn btn-primary dropdown-toggle m-r-20" type="button">
                        Action <span class="caret"></span>
                        </button>
                        <ul role="menu" class="dropdown-menu">
                          <li><a href="{{ route('admin.changestatus' , [$book->id , '0'])}}">Inprocess</a>
                          </li>
                          <li><a href="{{ route('admin.changestatus' , [$book->id , '1'])}}">Confirm</a>
                          </li>
                          <li><a href="{{ route('admin.changestatus' , [$book->id , '2'])}}">CheckedIn</a>
                          </li>
                          <li><a href="{{ route('admin.changestatus' , [$book->id , '3'])}}">CheckOut</a>
                          </li>
                          <li><a href="{{ route('admin.changestatus' , [$book->id , '4'])}}">Cancel</a>
                          </li>
                        </ul>
                      </div>
                    </td>
                  </tr>

                  @endforeach

                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- end page content -->


</div>
<!-- end page container -->
<!-- start footer -->
<div class="page-footer">
  <div class="page-footer-inner"> 2021 &copy;
    <a href="mailto:redstartheme@gmail.com" target="_top" class="makerCss">All Rights Reserved</a>
  </div>
  <div class="scroll-to-top">
    <i class="icon-arrow-up"></i>
  </div>
</div>
<!-- end footer -->
</div>
@endsection



@section('scripts')
<script src="{{ asset('admin/assets/plugins/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{ asset('admin/assets/plugins/datatables/plugins/bootstrap/dataTables.bootstrap4.min.js')}}"></script>
<script src="{{ asset('admin/assets/js/pages/table/table_data.js')}}"></script>
@endsection
