@extends('layouts.admin')



@section('styles')

@endsection



@section('content')
<div class="page-container">
@include('includes.sidebar')
<!-- start page content -->
<div class="page-content-wrapper">
  <div class="page-content">
    <div class="page-bar">
      <div class="page-title-breadcrumb">
        <div class=" pull-left">
          <div class="page-title">Gallery</div>
        </div>
        <ol class="breadcrumb page-breadcrumb pull-right">
          <li><i class="fa fa-home"></i>&nbsp;<a class="parent-item"
              href="index.html">Home</a>&nbsp;<i class="fa fa-angle-right"></i>
          </li>
          <li><a class="parent-item" href="#">Forms</a>&nbsp;<i class="fa fa-angle-right"></i>
          </li>
          <li class="active">Gallery</li>
        </ol>
      </div>
    </div>
    <!-- basic wizard -->
    <div class="row">
      <div class="col-sm-12">
        <div class="card-box">
          <div class="card-head">
            <header>Gallery</header>
          </div>
          <div class="card-body">
            <form action="{{ route('admin.addgallery')}}" method="post" enctype="multipart/form-data">

            <div id="wizard">
              <div class="row">
            <div class="col-lg-12 p-t-20">
              <label>Image</label>
              <input type="file" name="image" required class="form-control"></input>
            </div>
          </div>
            </div>

            <div id="wizard">
              <div class="row">
            <div class="col-lg-12 p-t-20">
              <input type="submit" value="Submit" class="form-control btn-success"/>
            </div>
          </div>
            </div>
            {{ csrf_field()}}
          </form>

          </div>

        </div>
      </div>
    </div>
    <!-- wizard with validation-->

    <!-- Verticle Steps Wizard -->
    <div class="row">
  <div class="col-sm-12">
    <div class="card-box">
      <div class="card-head">
        <header>Gallery List</header>
      </div>
      <div class="card-body ">
        <div class="state-overview">
        </div>

        <table class="table table-hover table-checkable order-column full-width"
          id="example4">
          <thead>
            <tr>
              <th class="center">No</th>
              <th class="center">Image Thumbnail</th>
              <th class="center">Action</th>
            </tr>
          </thead>
          <tbody>

            @foreach($gallery as $s)
            <tr>
              <td class="center">{{$loop->iteration}}</td>
              <td class="center user-circle-img sorting_1"><img src="{{ asset('storage/mainheader/'.$s->image)}}" style="width: 10%;" alt=""></td>

              <td class="center">

                <a class="btn btn-tbl-delete btn-xs" href="{{ route('admin.deletegallery', $s->id)}}">
                  <i class="fa fa-trash-o "></i>
                </a>
              </td>
            </tr>
            @endforeach

          </tbody>
        </table>
      </div>
    </div>
  </div>
  </div>
  </div>
</div>
<!-- end page content -->
<div class="page-footer">
  <div class="page-footer-inner"> 2021 &copy;
    <a href="#" target="_top" class="makerCss">All Rights Reserved</a>
  </div>
  <div class="scroll-to-top">
    <i class="icon-arrow-up"></i>
  </div>
</div>
</div>
@endsection



@section('scripts')


@endsection
