<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name', 'Laravel') }}</title>
    <!-- Fonts -->
    <!-- Styles -->

    <link href="{{ asset('log.png') }}" rel="shortcut icon" type="image/png">
    <link href="{{ asset('assets/main/images/apple-touch-icon.png')}}" rel="apple-touch-icon">
    <link href="{{ asset('assets/main/images/apple-touch-icon-72x72.png')}}" rel="apple-touch-icon" sizes="72x72">
    <link href="{{ asset('assets/main/images/apple-touch-icon-114x114.png')}}" rel="apple-touch-icon" sizes="114x114">
    <link href="{{ asset('assets/main/images/apple-touch-icon-144x144.png')}}" rel="apple-touch-icon" sizes="144x144">

    <!-- Stylesheet -->
    <link href="{{ asset('assets/main/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/main/css/jquery-ui.min.css')}}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/main/css/animate.css')}}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/main/css/css-plugin-collections.css')}}" rel="stylesheet"/>
    <!-- CSS | menuzord megamenu skins -->
    <link id="menuzord-menu-skins" href="{{ asset('assets/main/css/menuzord-skins/menuzord-rounded-boxed.css')}}" rel="stylesheet"/>
    <!-- CSS | Main style file -->
    <link href="{{ asset('assets/main/css/style-main.css')}}" rel="stylesheet" type="text/css">
    <!-- CSS | Preloader Styles -->
    <link href="{{ asset('assets/main/css/preloader.css')}}" rel="stylesheet" type="text/css">
    <!-- CSS | Custom Margin Padding Collection -->
    <link href="{{ asset('assets/main/css/custom-bootstrap-margin-padding.css')}}" rel="stylesheet" type="text/css">
    <!-- CSS | Responsive media queries -->
    <link href="{{ asset('assets/main/css/responsive.css')}}" rel="stylesheet" type="text/css">
    <!-- CSS | Style css. This is the file where you can place your own custom css code. Just uncomment it and use it. -->
    <!-- <link href="css/style.css" rel="stylesheet" type="text/css"> -->

    <!-- Revolution Slider 5.x CSS settings -->
    <link  href="{{ asset('assets/main/js/revolution-slider/css/settings.css')}}" rel="stylesheet" type="text/css"/>
    <link  href="{{ asset('assets/main/js/revolution-slider/css/layers.css')}}" rel="stylesheet" type="text/css"/>
    <link  href="{{ asset('assets/main/js/revolution-slider/css/navigation.css')}}" rel="stylesheet" type="text/css"/>

    <!-- CSS | Theme Color -->
    <link href="{{ asset('assets/main/css/colors/theme-skin-color-set-1.css')}}" rel="stylesheet" type="text/css">
    @yield('styles')
</head>

<body class="">


<div id="wrapper" class="clearfix">

@yield('content')

  <!-- Footer -->
  <footer id="footer" class="footer bg-red">
    <div class="container p-5">
      <div class="row">
          <div class="col-md-6">
            <p class="font-11 text-gray-gainsboro m-0">Copyright &copy;2021. All Rights Reserved</p>
          </div>
          <!-- <div class="col-md-6 text-right">
            <div class="widget no-border m-0">
              <ul class="list-inline sm-text-center font-12">
                <li> <a href="faq.html">FAQ</a> </li>
                <li>|</li>  <li><a href="franchise.html">Franchises</a> </li> <li><a href="contact.html">Contact Us</a>

              </li>
              </ul>
            </div>
          </div> -->
        </div>
    </div>
  </footer>
<a class="scrollToTop" href="#"><i class="fa fa-angle-up"></i></a>
</div>


<!-- external javascripts -->
<script src="{{ asset('assets/main/js/jquery-2.2.4.min.js')}}"></script>
<script src="{{ asset('assets/main/js/jquery-ui.min.js')}}"></script>
<script src="{{ asset('assets/main/js/bootstrap.min.js')}}"></script>
<!-- JS | jquery plugin collection for this theme -->
<script src="{{ asset('assets/main/js/jquery-plugin-collection.js')}}"></script>

<!-- Revolution Slider 5.x SCRIPTS -->
<script src="{{ asset('assets/main/js/revolution-slider/js/jquery.themepunch.tools.min.js')}}"></script>
<script src="{{ asset('assets/main/js/revolution-slider/js/jquery.themepunch.revolution.min.js')}}"></script>

<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
<!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->



<!-- Footer Scripts -->
<!-- JS | Custom script for all pages -->
<script src="{{ asset('assets/main/js/custom.js')}}"></script>

<!-- SLIDER REVOLUTION 5.0 EXTENSIONS
      (Load Extensions only on Local File Systems !
       The following part can be removed on Server for On Demand Loading) -->
<script type="text/javascript" src="{{ asset('assets/main/js/revolution-slider/js/extensions/revolution.extension.actions.min.js')}}"></script>
<script type="text/javascript" src="{{ asset('assets/main/js/revolution-slider/js/extensions/revolution.extension.carousel.min.js')}}"></script>
<script type="text/javascript" src="{{ asset('assets/main/js/revolution-slider/js/extensions/revolution.extension.kenburn.min.js')}}"></script>
<script type="text/javascript" src="{{ asset('assets/main/js/revolution-slider/js/extensions/revolution.extension.layeranimation.min.js')}}"></script>
<script type="text/javascript" src="{{ asset('assets/main/js/revolution-slider/js/extensions/revolution.extension.migration.min.js')}}"></script>
<script type="text/javascript" src="{{ asset('assets/main/js/revolution-slider/js/extensions/revolution.extension.navigation.min.js')}}"></script>
<script type="text/javascript" src="{{ asset('assets/main/js/revolution-slider/js/extensions/revolution.extension.parallax.min.js')}}"></script>
<script type="text/javascript" src="{{ asset('assets/main/js/revolution-slider/js/extensions/revolution.extension.slideanims.min.js')}}"></script>
<script type="text/javascript" src="{{ asset('assets/main/js/revolution-slider/js/extensions/revolution.extension.video.min.js')}}"></script>
@yield('scripts')

<script src="{{ asset('notify/bootstrap-notify.js') }}"></script>
<script src="{{ asset('notify/bootstrap-notify.min.js') }}"></script>
<script>
            @if(Session::has('success'))
            $.notify({
              title: '<strong>Success!</strong>',
              message: '{!! Session::get('success') !!}'
            },{
              type: 'success'
            });

            @elseif(Session::has('error'))
            $.notify({
              title: '<strong>Error!</strong>',
              message: '{!! Session::get('error') !!}'
            },{
              type: 'error'
            });

            @elseif(Session::has('warning'))
            $.notify({
              title: '<strong>Warning!</strong>',
              message: '{!! Session::get('warning') !!}'
            },{
              type: 'warning'
            });

            @endif
    </script>
</body>

</html>
