<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
   <meta charset="utf-8">
   <meta http-equiv="x-ua-compatible" content="ie=edge">
   <title>Mountain Retreat</title>
   <meta name="description" content="Mountain Retreat">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <link rel="manifest" href="Mountain Retreat">
   <link rel="shortcut icon" type="image/x-icon" href="{{ asset('web/assets/img/logo/favicon.ico') }}">
   <!-- CSS here -->
   <link rel="stylesheet" href="{{ asset('web/assets/css/bootstrap.min.css') }}">
   <link rel="stylesheet" href="{{ asset('web/assets/css/owl.carousel.min.css') }}">
   <link rel="stylesheet" href="{{ asset('web/assets/css/slicknav.css') }}">
   <link rel="stylesheet" href="{{ asset('web/assets/css/animate.min.css') }}">
   <link rel="stylesheet" href="{{ asset('web/assets/css/magnific-popup.css') }}">
   <link rel="stylesheet" href="{{ asset('web/assets/css/fontawesome-all.min.css') }}">
   <link rel="stylesheet" href="{{ asset('web/assets/css/themify-icons.css') }}">
   <link rel="stylesheet" href="{{ asset('web/assets/css/slick.css') }}">
   <link rel="stylesheet" href="{{ asset('web/assets/css/nice-select.css') }}">
   <link rel="stylesheet" href="{{ asset('web/assets/css/style.css') }}">
   <link rel="stylesheet" type="text/css" href="{{ asset('web/lightbox-gallery/jquery.lightbox.css') }}">

    @yield('styles')
</head>

<body >
@include('includes.header')
@yield('content')
@include('includes.footer')


<!-- JS here -->
<!-- All JS Custom Plugins Link Here here -->
<script src="{{ asset('web/assets/js/vendor/modernizr-3.5.0.min.js') }}"></script>
<!-- Jquery, Popper, Bootstrap -->
<script src="{{ asset('web/assets/js/vendor/jquery-1.12.4.min.js') }}"></script>
<script src="{{ asset('web/assets/js/popper.min.js') }}"></script>
<script src="{{ asset('web/assets/js/bootstrap.min.js') }}"></script>
<!-- Jquery Mobile Menu -->
<script src="{{ asset('web/assets/js/jquery.slicknav.min.js') }}"></script>
<!-- Jquery Slick , Owl-Carousel Plugins -->
<script src="{{ asset('web/assets/js/owl.carousel.min.js') }}"></script>
<script src="{{ asset('web/assets/js/slick.min.js') }}"></script>
<!-- One Page, Animated-HeadLin -->
<script src="{{ asset('web/assets/js/wow.min.js') }}"></script>
<script src="{{ asset('web/assets/js/animated.headline.js') }}"></script>
<script src="{{ asset('web/assets/js/jquery.magnific-popup.js') }}"></script>
<!-- Scrollup, nice-select, sticky -->
<script src="{{ asset('web/assets/js/jquery.scrollUp.min.js') }}"></script>
<script src="{{ asset('web/assets/js/jquery.nice-select.min.js') }}"></script>
<script src="{{ asset('web/assets/js/jquery.sticky.js') }}"></script>
<!-- Jquery Plugins, main Jquery -->
<script src="{{ asset('web/assets/js/plugins.js') }}"></script>
<script src="{{ asset('web/assets/js/main.js') }}"></script>

<script>
jQuery(document).ready(function(){

/* Open lightbox on button click */
$('.lightbox-toggle').click(function(){
$('.backdrop').animate({'opacity':'.95'}, 300, 'linear').css('display', 'block');
});

/* Click to close lightbox */
$('.close, .backdrop').click(function(){
$('.backdrop').animate({'opacity':'0'}, 300, 'linear', function(){
$('.backdrop').css('display', 'none');

});


});

});
</script>
<script src="{{ asset('web/lightbox-gallery/jquery.lightbox.js') }}"></script>
  <script>
  // Initiate Lightbox
  $(function() {
      $('.gallery a').lightbox();
  });
  </script>
</body>
</html>

@yield('scripts')
  <script src="{{ asset('notify/bootstrap-notify.js') }}"></script>
  <script src="{{ asset('notify/bootstrap-notify.min.js') }}"></script>
  <script>
              @if(Session::has('success'))
              $.notify({
              	title: '<strong>Success!</strong>',
              	message: '{!! Session::get('success') !!}'
              },{
              	type: 'success'
              });

              @elseif(Session::has('error'))
              $.notify({
              	title: '<strong>Error!</strong>',
              	message: '{!! Session::get('error') !!}'
              },{
              	type: 'error'
              });

              @elseif(Session::has('warning'))
              $.notify({
              	title: '<strong>Warning!</strong>',
              	message: '{!! Session::get('warning') !!}'
              },{
              	type: 'warning'
              });

              @endif
      </script>
</body>

</html>
