<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });
Route::get('/', 'Web\WebController@index')->name('main');
Route::get('/booking', 'Web\WebController@booking')->name('booking');
Route::post('/submitbooking', 'Web\WebController@submitbooking')->name('submitbooking');
Route::get('/services', 'Web\WebController@services')->name('services');
Route::get('/gallery', 'Web\WebController@gallery')->name('gallery');
Route::get('/about', 'Web\WebController@about')->name('about');
Route::get('/thanks/{id}', 'Web\WebController@thanks')->name('thanks');


Route::post('/submitcontact', 'Web\WebController@submitcontact')->name('submitcontact');

Auth::routes();
// to verify the role of the users
Route::get('/home', 'HomeController@loginCheck')->name('home');
Route::get('/user/logout', 'HomeController@userLogout')->name('user.logout');
// admin controllers
Route::middleware('auth')->prefix('admin')->group(function() {
          Route::get('/dashboard', 'Admin\AdminController@dashboard')->name('admin.dashboard');
          Route::post('/changepass', 'Admin\AdminController@changepass')->name('admin.changepass');

          Route::get('/changestatus/{id}/{val}', 'Admin\AdminController@changestatus')->name('admin.changestatus');


          Route::get('/sliders', 'Admin\AdminController@sliders')->name('admin.sliders');
          Route::get('/deleteslider/{id}', 'Admin\AdminController@deleteslider')->name('admin.deleteslider');
          Route::post('/addsliders', 'Admin\AdminController@addsliders')->name('admin.addsliders');


          Route::get('/comments', 'Admin\AdminController@comments')->name('admin.comments');
          Route::post('/addcomment', 'Admin\AdminController@addcomment')->name('admin.addcomment');
          Route::get('/deletecomments/{id}', 'Admin\AdminController@deletecomments')->name('admin.deletecomments');

          Route::get('/abouts', 'Admin\AdminController@abouts')->name('admin.abouts');
          Route::post('/editabout', 'Admin\AdminController@editabout')->name('admin.editabout');

          Route::get('/video', 'Admin\AdminController@video')->name('admin.video');
          Route::post('/editvideo', 'Admin\AdminController@editvideo')->name('admin.editvideo');

          Route::get('/gallery', 'Admin\AdminController@gallery')->name('admin.gallery');
          Route::post('/addgallery', 'Admin\AdminController@addgallery')->name('admin.addgallery');
          Route::get('/deletegallery/{id}', 'Admin\AdminController@deletegallery')->name('admin.deletegallery');



          Route::get('/bookings', 'Admin\AdminController@bookings')->name('admin.bookings');


});
