<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Modals\Menu;
use App\Modals\Brand;
use App\Modals\Submenu;
use App\Modals\Color;
use App\Modals\Size;
use App\Modals\Product;
use App\Modals\Main;
use App\Modals\Box;
use App\Modals\Secbox;
use App\Modals\Addbox;
use Session;
use App\User;
use Hash;
use Auth;


class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
         $this->middleware('auth');
         $this->middleware('adminuser');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function dashboard()
    {

        return view('admin.dashboard');
    }


    public function brands()
    {
        $brands = Brand::all();
        return view('admin.brands', ['brands'=>$brands]);
    }

    public function menus()
    {
        $menus = Menu::all();
        return view('admin.menus', ['menus'=>$menus]);
    }

    public function submenus()
    {
        $submenus = Submenu::all();
        $menus = Menu::all();

        return view('admin.submenus', ['submenus'=>$submenus,'menus'=>$menus]);
    }

    public function products()
    {
        $products = Product::all();
        $submenus = Submenu::all();
          $brands = Brand::all();
        return view('admin.products', ['submenus'=>$submenus,'products'=>$products,'brands'=>$brands]);
    }

    public function getmains()
    {
        $main = Main::first();

        return view('admin.mains', ['main'=>$main]);
    }


    public function editmains(Request $request)
    {
        $main = Main::first();
        $main->h1 = $request->h1;
        $main->h2 = $request->h2;
        $main->h3 = $request->h3;

        if($request->pic)
        {
        $value = $request->pic;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $main->pic =  $namefile;
        }

        $main->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }



    public function getboxes()
    {
        $box = Box::first();

        return view('admin.boxes', ['box'=>$box]);
    }


    public function editboxes(Request $request)
    {
        $box = Box::first();
        $box->ah1 = $request->ah1;
        $box->ah2 = $request->ah2;
        $box->bh1 = $request->bh1;
        $box->bh2 = $request->bh2;
        $box->ch1 = $request->ch1;
        $box->ch2 = $request->ch2;

        if($request->image1)
        {
        $value = $request->image1;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image1 =  $namefile;
        }

        if($request->image2)
        {
        $value = $request->image2;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image2 =  $namefile;
        }

        if($request->image3)
        {
        $value = $request->image3;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image3 =  $namefile;
        }

        $box->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }



    public function getsecboxes()
    {
        $box = Secbox::first();

        return view('admin.secboxes', ['box'=>$box]);
    }


    public function editsecboxes(Request $request)
    {
        $box = Secbox::first();
        $box->ah1 = $request->ah1;
        $box->ah2 = $request->ah2;
        $box->bh1 = $request->bh1;
        $box->bh2 = $request->bh2;


        if($request->image1)
        {
        $value = $request->image1;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image1 =  $namefile;
        }

        if($request->image2)
        {
        $value = $request->image2;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image2 =  $namefile;
        }


        $box->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }


    public function getaddboxes()
    {
        $box = Addbox::first();

        return view('admin.addboxes', ['box'=>$box]);
    }


    public function editaddboxes(Request $request)
    {
        $box = addbox::first();
        $box->h1 = $request->h1;
        $box->h2 = $request->h2;
        $box->h3 = $request->h3;
        $box->h4 = $request->h4;


        if($request->image)
        {
        $value = $request->image;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/mainheader', $namefile);
        $box->image =  $namefile;
        }



        $box->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }

    public function addbrands(Request $request)
    {
        $brands = new Brand();
        $brands->name = $request->name;
        $brands->save();

        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }

    public function addmenus(Request $request)
    {
        $menus = new Menu();
        $menus->name = $request->name;
        $menus->save();


        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }

    public function addsubmenus(Request $request)
    {
        $submenus = new Submenu();
        $submenus->name = $request->name;
        $submenus->menu_id = $request->menu_id;
        $submenus->save();


        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }


    public function addproducts(Request $request)
    {
      $mm = Submenu::where('id', $request->menu_id)->first();

        $product = new Product();
        $product->name = $request->name;
        $product->details = $request->details;
        $product->description = $request->description;
        $product->brand_id = $request->brand_id;
        $product->menu_id = $mm->menu_id;
        $product->submenu_id = $request->menu_id;
        $product->price = $request->price;
        $product->stock = $request->stock;


        if($request->image1)
        {
        $value = $request->image1;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image1 =  $namefile;
        }

        if($request->image2)
        {
        $value = $request->image2;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image2 =  $namefile;
        }

        if($request->image3)
        {
        $value = $request->image3;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image3 =  $namefile;
        }

        if($request->image4)
        {
        $value = $request->image4;
        $namefile = uniqid().".".$value->getClientOriginalExtension();
        $value->storeAs('public/products', $namefile);
        $product->image4 =  $namefile;
        }

        $product->save();

        $myArray = explode(',', $request->colors);
        foreach($myArray as $ma)
        {
        $color = new Color();
        $color->product_id = $product->id;
        $color->name = $ma;
        $color->save();
        }

        $myArray1 = explode(',', $request->sizes);
        foreach($myArray1 as $ma1)
        {
        $size = new Size();
        $size->product_id = $product->id;
        $size->name = $ma1;
        $size->save();
        }


        Session::flash('success', 'Successfully, Added !');
        return redirect()->back();
    }
}
