<?php

namespace App\Http\Controllers\Web;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Modals\Menu;
use App\Modals\Brand;
use App\Modals\Submenu;
use App\Modals\Color;
use App\Modals\Size;
use App\Modals\Product;
use App\Modals\Main;
use App\Modals\Box;
use App\Modals\Secbox;
use App\Modals\Addbox;
use Session;
use App\User;
use Hash;
use Auth;

class WebController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {

      $menus = Menu::all();
      $brands = Brand::all();
      $main = Main::first();
      $box = Box::first();
      $secbox = Secbox::first();
      $addbox = Addbox::first();
      return view('web.index', ['menus'=>$menus,'brands'=>$brands,'main'=>$main,'box'=>$box,'secbox'=>$secbox,'addbox'=>$addbox]);
    }
    public function itemLists($type,$id)
    {
      if(!isset($type) && $type == null && !isset($id) && $id == null)
      {
        return redirect()->route('main');
      }

      if($type == "brand")
      {
        $products = Product::where('brand_id', $id)->get();
        $txt = Brand::where('id', $id)->first();
      }
      if($type == "submenu")
      {
        $products = Product::where('submenu_id', $id)->get();
        $txt = Submenu::where('id', $id)->first();
      }
      if($type == "menu")
      {
        $products = Product::where('menu_id', $id)->get();
        $txt = Menu::where('id', $id)->first();
      }


      $menus = Menu::all();
      $submenus = Submenu::all();
      $brands = Brand::all();
      $type = $type;
      return view('web.itemLists', ['menus'=>$menus,'brands'=>$brands,'submenus'=>$submenus,'type'=>$type,'products'=>$products,'txt'=>$txt]);
    }
    public function itemDetail($id)
    {
      if(!isset($id) && $id == null)
      {
        return redirect()->route('main');
      }
      $menus = Menu::all();
      $brands = Brand::all();
      $product = Product::where('id', $id)->first();
      return view('web.itemDetail', ['menus'=>$menus,'brands'=>$brands,'product'=>$product]);
    }
    public function cart()
    {
      $menus = Menu::all();
      $brands = Brand::all();
        return view('web.cart', ['menus'=>$menus,'brands'=>$brands]);
    }
    public function checkout()
    {
        return view('web.checkout');
    }
    public function contact()
    {
      $menus = Menu::all();
      $brands = Brand::all();
        return view('web.contact', ['menus'=>$menus,'brands'=>$brands]);
    }

    public function about()
    {
      $menus = Menu::all();
      $brands = Brand::all();
        return view('web.about', ['menus'=>$menus,'brands'=>$brands]);
    }

}
