@extends('layouts.main')

@section('styles')
@endsection

@section('content')
@include('includes.header')
<!-- Slider Area -->
<section class="hero-slider">
  <!-- Single Slider -->
  <div class="single-slider" style="background-image:url({{ asset('storage/mainheader/'.$main->pic)}})">
    <div class="container">
      <div class="row no-gutters">
        <div class="col-lg-9 offset-lg-3 col-12">
          <div class="text-inner">
            <div class="row">
              <div class="col-lg-7 col-12">
                <div class="hero-text">
                  <h1><span>{{$main->h1}} </span>{{$main->h2}}</h1>
                  <p>{{$main->h3}}</p>
                  <div class="button">
                    <a href="#" class="btn">Shop Now!</a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <!--/ End Single Slider -->
</section>
<!--/ End Slider Area -->

<!-- Start Small Banner  -->
<section class="small-banner section">
  <div class="container-fluid">
    <div class="row">
      <!-- Single Banner  -->
      <div class="col-lg-4 col-md-6 col-12">
        <div class="single-banner">
          <img src="{{ asset('storage/mainheader/'.$box->image1)}}" alt="#">
          <div class="content">
            <p>{{$box->ah1}}</p>
            <h3>{{$box->ah2}}</h3>

          </div>
        </div>
      </div>
      <!-- /End Single Banner  -->
      <!-- Single Banner  -->
      <div class="col-lg-4 col-md-6 col-12">
        <div class="single-banner">
          <img src="{{ asset('storage/mainheader/'.$box->image2)}}" alt="#">
          <div class="content">
            <p>{{$box->bh1}}</p>
            <h3>{{$box->bh2}}</h3>

          </div>
        </div>
      </div>
      <!-- /End Single Banner  -->
      <!-- Single Banner  -->
      <div class="col-lg-4 col-12">
        <div class="single-banner tab-height">
          <img src="{{ asset('storage/mainheader/'.$box->image3)}}" alt="#">
          <div class="content">
            <p>{{$box->ch1}}</p>
            <h3>{{$box->ch2}}</h3>
          </div>
        </div>
      </div>
      <!-- /End Single Banner  -->
    </div>
  </div>
</section>
<!-- End Small Banner -->

<!-- Start Product Area -->
  <div class="product-area section">
          <div class="container">
      <div class="row">
        <div class="col-12">
          <div class="section-title">
            <h2>Trending Item</h2>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-12">
          <div class="product-info">
            <div class="nav-main">
              <!-- Tab Nav -->
              <ul class="nav nav-tabs" id="myTab" role="tablist">
                @foreach($menus->take(5) as $smallmenu)
                <li class="nav-item"><a class="nav-link @if($loop->iteration ==1) active @endif" data-toggle="tab" href="#tabmenu_{{$smallmenu->id}}" role="tab">{{$smallmenu->name}}</a></li>
                @endforeach

              </ul>
              <!--/ End Tab Nav -->
            </div>
            <div class="tab-content" id="myTabContent">
              <!-- Start Single Tab -->

              @foreach($menus->take(5) as $smallmenu)
              <div class="tab-pane fade show @if($loop->iteration ==1) active @endif" id="tabmenu_{{$smallmenu->id}}" role="tabpanel">
                <div class="tab-single">
                  <div class="row">

                    @foreach($smallmenu->products->take(10) as $prosmal)
                    <div class="col-xl-3 col-lg-4 col-md-4 col-12">
                      <div class="single-product">
                        <div class="product-img">
                          <a href="{{ route('itemDetail' , $prosmal->id)}}">
                            <img class="default-img" src="{{ asset('storage/products/'.$prosmal->image1)}}" alt="#">
                            <img class="hover-img" src="{{ asset('storage/products/'.$prosmal->image1)}}" alt="#">
                          </a>
                          <div class="button-head">
                            <div class="product-action">
                              <a   title="Quick View" href="{{ route('itemDetail' , $prosmal->id)}}"><i class=" ti-eye"></i><span>Quick Shop</span></a>

                            </div>
                            <div class="product-action-2">
                              <a title="Add to cart" href="#">Add to cart</a>
                            </div>
                          </div>
                        </div>
                        <div class="product-content">
                          <h3><a href="{{ route('itemDetail' , $prosmal->id)}}">{{$prosmal->name}}</a></h3>
                          <div class="product-price">
                            <span>{{$prosmal->price}} PKR</span>
                          </div>
                        </div>
                      </div>
                    </div>
                    @endforeach






                  </div>
                </div>
              </div>
              @endforeach
              <!--/ End Single Tab -->





            </div>
          </div>
        </div>
      </div>
          </div>
  </div>
<!-- End Product Area -->

<!-- Start Midium Banner  -->
<section class="midium-banner">
  <div class="container">
    <div class="row">
      <!-- Single Banner  -->
      <div class="col-lg-6 col-md-6 col-12">
        <div class="single-banner">
          <img src="{{ asset('storage/mainheader/'.$secbox->image1)}}" alt="#">
          <div class="content">
            <p>{{$secbox->ah1}}</p>
            <h3>{{$secbox->ah2}}</h3>
            <a href="#">Shop Now</a>
          </div>
        </div>
      </div>
      <!-- /End Single Banner  -->
      <!-- Single Banner  -->
      <div class="col-lg-6 col-md-6 col-12">
        <div class="single-banner">
          <img src="{{ asset('storage/mainheader/'.$secbox->image2)}}" alt="#">
          <div class="content">
            <p>{{$secbox->bh1}}</p>
            <h3>{{$secbox->bh2}}</h3>
            <a href="#" class="btn">Shop Now</a>
          </div>
        </div>
      </div>
      <!-- /End Single Banner  -->
    </div>
  </div>
</section>
<!-- End Midium Banner -->


<!-- End Most Popular Area -->

<!-- End Shop Home List  -->

<!-- Start Cowndown Area -->
<section class="cown-down" style="margin-top:50px;">
  <div class="section-inner ">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-6 col-12 padding-right">
          <div class="image">
            <img src="{{ asset('storage/mainheader/'.$addbox->image)}}" alt="#">
          </div>
        </div>
        <div class="col-lg-6 col-12 padding-left">
          <div class="content">
            <div class="heading-block">
              <p class="small-title">{{$addbox->h1}}</p>
              <h3 class="title">{{$addbox->h2}}</h3>
              <p class="text">{{$addbox->h3}} </p>
              <h1 class="price">{{$addbox->h4}}</h1>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- /End Cowndown Area -->

<!-- Start Shop Services Area -->
<section class="shop-services section home">
  <div class="container">
    <div class="row">
      <div class="col-lg-3 col-md-6 col-12">
        <!-- Start Single Service -->
        <div class="single-service">
          <i class="ti-rocket"></i>
          <h4>Shiping</h4>
          <p>we ship all over the country</p>
        </div>
        <!-- End Single Service -->
      </div>
      <div class="col-lg-3 col-md-6 col-12">
        <!-- Start Single Service -->
        <div class="single-service">
          <i class="ti-reload"></i>
          <h4>No Returns</h4>
          <p>30% deduction on order cancelation</p>
        </div>
        <!-- End Single Service -->
      </div>
      <div class="col-lg-3 col-md-6 col-12">
        <!-- Start Single Service -->
        <div class="single-service">
          <i class="ti-lock"></i>
          <h4>No Exchange policy</h4>
          <p>30% deduction on order cancelation</p>
        </div>
        <!-- End Single Service -->
      </div>
      <div class="col-lg-3 col-md-6 col-12">
        <!-- Start Single Service -->
        <div class="single-service">
          <i class="ti-tag"></i>
          <h4>Best Peice</h4>
          <p>Guaranteed price</p>
        </div>
        <!-- End Single Service -->
      </div>
    </div>
  </div>
</section>
<!-- End Shop Services Area -->



@endsection

@section('scripts')
@endsection
