<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });
Route::get('/', 'Web\WebController@index')->name('main');
Route::get('/items-list/{type}/{id}', 'Web\WebController@itemLists')->name('itemLists');
Route::get('/item-detail/{id}', 'Web\WebController@itemDetail')->name('itemDetail');
Route::get('/cart', 'Web\WebController@cart')->name('cart');
Route::get('/checkout', 'Web\WebController@checkout')->name('checkout');
Route::get('/contact', 'Web\WebController@contact')->name('contact');
Route::get('/about', 'Web\WebController@about')->name('about');

Auth::routes();
// to verify the role of the users
Route::get('/home', 'HomeController@loginCheck')->name('home');
Route::get('/user/logout', 'HomeController@userLogout')->name('user.logout');
// admin controllers
Route::middleware('auth')->prefix('admin')->group(function() {
          Route::get('/dashboard', 'Admin\AdminController@dashboard')->name('admin.dashboard');

          Route::get('/brands', 'Admin\AdminController@brands')->name('admin.brands');
          Route::post('/addbrands', 'Admin\AdminController@addbrands')->name('admin.addbrands');

          Route::get('/menus', 'Admin\AdminController@menus')->name('admin.menus');
          Route::post('/addmenus', 'Admin\AdminController@addmenus')->name('admin.addmenus');

          Route::get('/submenus', 'Admin\AdminController@submenus')->name('admin.submenus');
          Route::post('/addsubmenus', 'Admin\AdminController@addsubmenus')->name('admin.addsubmenus');

          Route::get('/products', 'Admin\AdminController@products')->name('admin.products');
          Route::post('/addproducts', 'Admin\AdminController@addproducts')->name('admin.addproducts');

          Route::get('/getmains', 'Admin\AdminController@getmains')->name('admin.getmains');
          Route::post('/editmains', 'Admin\AdminController@editmains')->name('admin.editmains');

          Route::get('/getboxes', 'Admin\AdminController@getboxes')->name('admin.getboxes');
          Route::post('/editboxes', 'Admin\AdminController@editboxes')->name('admin.editboxes');


          Route::get('/getsecboxes', 'Admin\AdminController@getsecboxes')->name('admin.getsecboxes');
          Route::post('/editsecboxes', 'Admin\AdminController@editsecboxes')->name('admin.editsecboxes');

          Route::get('/getaddboxes', 'Admin\AdminController@getaddboxes')->name('admin.getaddboxes');
          Route::post('/editaddboxes', 'Admin\AdminController@editaddboxes')->name('admin.editaddboxes');
});
