<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Category;
use App\Models\Product;
use App\Models\Slider;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {

    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {

        return view('dashboard');
    }

    public function products()
    {
        $products = Product::all();
        return view('products',['products'=>$products]);
    }

    public function categories()
    {
        $categories = Category::all();
        return view('categories',['categories'=>$categories]);
    }

    public function sliders()
    {
      $sliders = Slider::all();
      return view('sliders',['sliders'=>$sliders]);
    }
    
      public function deleteslider($id)
    {
      $sliders = Slider::where('id',$id)->first();
      $sliders->delete();
      return redirect()->back();
    }

    public function addslider(Request $request)
    {
      if($request->file)
    {

    $siler = new Slider();
     $value = $request->file;
     $namefile = uniqid().".".$value->getClientOriginalExtension();
     $value->storeAs('public/myfiles', $namefile);
     $siler->name =  $namefile;
     $siler->url = asset('storage/myfiles/'.$namefile);
     $siler->save();
    }
      return redirect()->back();
    }
  
    
    
    
        public function editcategory(Request $request)
    {
        
        $category = Category::where('id',$request->id)->first();
        $category->name = $request->name;
      if($request->file)
    {

     $value = $request->file;
     $namefile = uniqid().".".$value->getClientOriginalExtension();
     $value->storeAs('public/myfiles', $namefile);
     $category->icon = asset('storage/myfiles/'.$namefile);
    
    }
    
     $category->save();
      return redirect()->back();
    }
    
    
    
    
    
    
    public function addproduct(Request $request)
    {
         
        
         $siler = new Product();
         $siler->name = $request->name;
         $siler->description = $request->description;
         $siler->qty = $request->qty;
         $siler->price = $request->price;
      if($request->file)
    {
     $value = $request->file;
     $namefile = uniqid().".".$value->getClientOriginalExtension();
     $value->storeAs('public/myfiles', $namefile);
     $siler->image = asset('storage/myfiles/'.$namefile);
    }
    
     $siler->save();
      return redirect()->back();
    }



}
