<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Validator;
use JWTAuth;
use App\Models\User;
use App\Models\Slider;
use App\Models\Category;
use App\Models\Product;
use App\Models\Contact;
use App\Models\Warehousing;
use App\Models\CourierService;
use App\Models\MovingService;
use App\Models\SecureOrder;
use App\Models\Shipping;
class JWTAuthController extends Controller
{
    /**
     * Create a new AuthController instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth:api', ['except' => ['login', 'register','contact_us']]);
    }
    /**
     * Register a User.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function register(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|between:2,100',
            'last_name' => 'between:2,100',
            'email' => 'required|email|unique:users|max:50',
            'password' => 'required|confirmed|string|min:6',
        ]);

        if ($validator->fails()) {
          return response()->json(['error' => $validator->messages(),'error_code'=> 1], 200);
      }
        $user = User::create(array_merge(
                    $validator->validated(),
                    ['password' => bcrypt($request->password)]
                ));
        return response()->json([
            'message' => 'Successfully registered',
             'success' => true,
             'error_code' => 0,
            'user' => $user
        ], 201);
    }
    /**
     * Get a JWT via given credentials.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function login(Request $request)
    {
      $credentials = $request->only('email', 'password');

      //valid credential
      $validator = Validator::make($credentials, [
          'email' => 'required|email',
          'password' => 'required|string|min:6|max:50'
      ]);

      //Send failed response if request is not valid
      if ($validator->fails()) {
          return response()->json(['error' => $validator->messages(), 'error_code'=>1], 200);
      }

      //Request is validated
      //Crean token
      try {
          if (! $token = JWTAuth::attempt($credentials)) {
              return response()->json([
                'success' => false,
                'message' => 'Login credentials are invalid.',
                'error_code' => 1,
              ], 400);
          }
      } catch (JWTException $e) {
    return $credentials;
          return response()->json([
                'success' => false,
                'message' => 'Could not create token.',
                 'error_code' => 1,
              ], 500);
      }
    $user = User::where('email',$request->email)->first();
  //Token created, return with success response and jwt token
      return response()->json([
          'success' => true,
          'token' => $token,
           'error_code' => 0,
           'user' => $user,
      ]);
  }
    /**
     * Get the authenticated User.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function profile()
    {
        return response()->json(auth()->user());
    }
    /**
     * Log the user out (Invalidate the token).
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function logout()
    {
        auth()->logout();
        return response()->json(['message' => 'Successfully logged out']);
    }
    /**
     * Refresh a token.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function refresh()
    {
        return $this->createNewToken(auth()->refresh());
    }
    /**
     * Get the token array structure.
     *
     * @param  string $token
     *
     * @return \Illuminate\Http\JsonResponse
     */
    protected function createNewToken($token)
    {
        return response()->json([
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth()->factory()->getTTL() * 60
        ]);
    }






    public function dashboard()
    {
        $categories = Category::all();
        $sliders = Slider::all();

        $data = [
          'categories' =>$categories,
          'sliders'  => $sliders
        ];
        return response()->json(['message' => 'success' , 'data'=>$data, 'error_code' => 0,]);
    }


    public function products()
    {
        $products = Product::all();

        $data = [
          'products' =>$products,
        ];
        return response()->json(['message' => 'success' , 'data'=>$data, 'error_code' => 0,]);
    }
    
    
    
    
    public function productDetail(Request $request)
    {
        $products = Product::where('id',$request->product_id);

        $data = [
          'product' =>$products,
        ];
        return response()->json(['message' => 'success' , 'data'=>$data, 'error_code' => 0,]);
    }
    
    
    
    
    public function updateProfile(Request $request)
    {
        $user = User::where('id',$request->user_id)->first();
        $user->name = $request->first_name;
        $user->last_name = $request->last_name;
        $user->phone = $request->phone;
        $user->address_1 = $request->address_1;
        $user->address_2 = $request->address_2;
        $user->city = $request->city;
        $user->street = $request->street;
        $user->country = $request->country;
        $user->save();

        $data = [
          'user' =>$user,
        ];
        return response()->json(['message' => 'success' , 'data'=>$data, 'error_code' => 0,]);
    }
    
    
     public function contact_us(Request $request)
    {
        $contact = new Contact();
        $contact->name = $request->name;
        $contact->email = $request->email;
        $contact->phone = $request->phone;
        $contact->message = $request->message;
        $contact->date = $request->date; 
        $contact->save();

        $data = [
          'contact' =>$contact,
        ];
        return response()->json(['message' => 'success' , 'data'=>$data, 'error_code' => 0,]);
    }
    
    
     
     public function reset_password(Request $request)
    {
        $user = User::where('id',$request->user_id)->first();
        $user->password = bcrypt($request->password); 
        $user->save();

        $data = [
          'user' =>$user,
        ];
        return response()->json(['message' => 'success' , 'data'=>$data, 'error_code' => 0,]);
    }



    public function shipping(Request $request)
    {
        $data = new Shipping();
        $data->name = $request->name;
        $data->phone = $request->phone;
        $data->move_from = $request->move_from;
        $data->move_to = $request->move_to;
        $data->date = $request->date;
        $data->user_id = $request->user_id;
        $data->save();

        $data = [
          'data' =>$data,
        ];
        return response()->json(['message' => 'success' , 'data'=>$data, 'error_code' => 0,]);
    }
    
    public function courierservice(Request $request)
    {
        $data = new CourierService();
        $data->name = $request->name;
        $data->phone = $request->phone;
        $data->move_from = $request->move_from;
        $data->move_to = $request->move_to;
        $data->date = $request->date;
        $data->user_id = $request->user_id;
        $data->weight = $request->weight;
        $data->save();

        $data = [
          'data' =>$data,
        ];
        return response()->json(['message' => 'success' , 'data'=>$data, 'error_code' => 0,]);
    }
    
    public function movingservice(Request $request)
    {
        $data = new MovingService();
        $data->name = $request->name;
        $data->phone = $request->phone;
        $data->move_from = $request->move_from;
        $data->move_to = $request->move_to;
        $data->date = $request->date;
        $data->user_id = $request->user_id;
        $data->save();

        $data = [
          'data' =>$data,
        ];
        return response()->json(['message' => 'success' , 'data'=>$data, 'error_code' => 0,]);
    }
    
    public function secureorder(Request $request)
    {
        $data = new SecureOrder();
        $data->name = $request->name;
        $data->phone = $request->phone;
        $data->move_from = $request->move_from;
        $data->move_to = $request->move_to;
        $data->date = $request->date;
        $data->user_id = $request->user_id;
        $data->save();

        $data = [
          'data' =>$data,
        ];
        return response()->json(['message' => 'success' , 'data'=>$data, 'error_code' => 0,]);
    }
    
    public function warehouse(Request $request)
    {
        $data = new Warehousing();
        $data->name = $request->name;
        $data->phone = $request->phone;
        $data->move_date = $request->move_date;
        $data->end_date = $request->end_date;
        $data->ac = $request->ac;
        $data->user_id = $request->user_id;
        $data->save();

        $data = [
          'data' =>$data,
        ];
        return response()->json(['message' => 'success' , 'data'=>$data, 'error_code' => 0,]);
    }
       





}
