<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\JWTAuthController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::group([
    'middleware' => 'api',
    'prefix' => 'auth'
], function ($router) {
    Route::post('register', [JWTAuthController::class, 'register']);
    Route::post('login', [JWTAuthController::class, 'login']);
    Route::post('logout', [JWTAuthController::class, 'logout']);
    Route::post('refresh', [JWTAuthController::class, 'refresh']);
    Route::post('get_user', [JWTAuthController::class, 'get_user']);
    Route::post('dashboard', [JWTAuthController::class, 'dashboard']);
    Route::post('products', [JWTAuthController::class, 'products']);
    Route::post('productDetail', [JWTAuthController::class, 'productDetail']);
    Route::post('updateProfile', [JWTAuthController::class, 'updateProfile']);
    Route::post('contact_us', [JWTAuthController::class, 'contact_us']);
    Route::post('reset_password', [JWTAuthController::class, 'reset_password']);
    
    
    Route::post('warehouse', [JWTAuthController::class, 'warehouse']);
    Route::post('secureorder', [JWTAuthController::class, 'secureorder']);
    Route::post('movingservice', [JWTAuthController::class, 'movingservice']);
    Route::post('courierservice', [JWTAuthController::class, 'courierservice']);
    Route::post('shipping', [JWTAuthController::class, 'shipping']);
});
