<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Modals\Activity;
use Hash;
use Auth;
use Carbon\Carbon;
use Session;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function loginCheck()
    {
        $user = \Auth::user();

        if($user->hasRole('Super Admin'))
        {
        Session::flash('success', 'Successfully, Logged In !');
        return redirect()->route('admin.dashboard');
        }
        if($user->hasRole('Admin'))
        {
        Session::flash('success', 'Successfully, Logged In !');
        return redirect()->route('admin.dashboard');
        }
        if($user->hasRole('Student'))
        {
        Session::flash('success', 'Successfully, Logged In !');
        return redirect()->route('student.dashboard');
        }
        if($user->hasRole('Teacher'))
        {

        Session::flash('success', 'Successfully, Logged In !');
        return redirect()->route('teacher.dashboard');
        }
        Session::flash('error', 'Session Logged out!');
        return redirect()->route('user.logout');
    }


    public function loginhome()
    {
        $user = \Auth::user();
        $activity = new Activity();
        $activity->user_id = $user->id;
        $activity->activity_time = Carbon::now();
        $activity->activity_type = "login";
        $activity->save();
        if($user->hasRole('Super Admin'))
        {
        Session::flash('success', 'Successfully, Logged In !');
        return redirect()->route('admin.dashboard');
        }
        if($user->hasRole('Admin'))
        {
        Session::flash('success', 'Successfully, Logged In !');
        return redirect()->route('admin.dashboard');
        }
        if($user->hasRole('Student'))
        {
        Session::flash('success', 'Successfully, Logged In !');
        return redirect()->route('student.dashboard');
        }
        if($user->hasRole('Teacher'))
        {
        Session::flash('success', 'Successfully, Logged In !');
        return redirect()->route('teacher.dashboard');
        }
        Session::flash('error', 'Session Logged out!');
        return redirect()->route('user.logout');
    }

    public function userLogout(Request $request)
    {
      $user = \Auth::user();
      $activity = new Activity();
      $activity->user_id = $user->id;
      $activity->activity_time = Carbon::now();
      $activity->activity_type = "logout";
      $activity->activity_method = "self";
      $activity->save();
        Auth::logout();
        $request->session()->invalidate();
        Session::flash('success', 'Session Logged out!');
        return redirect()->route('login');
    }

    public function userLogout2(Request $request)
    {
    
        Auth::logout();
        $request->session()->invalidate();
        Session::flash('success', 'Session Logged out!');
        return redirect()->route('login');
    }
}
