<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('students', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('family_name')->nullable();
            $table->string('given_name')->nullable();
            $table->string('oen')->nullable();
            $table->string('medical')->nullable();
            $table->string('gender')->nullable();
            $table->string('dob')->nullable();
            $table->string('residency_proof')->nullable();
            $table->string('status_canada')->nullable();
            $table->string('street')->nullable();
            $table->string('apart')->nullable();
            $table->string('postal')->nullable();
            $table->string('city')->nullable();
            $table->string('province')->nullable();
            $table->string('cell_no')->nullable();
            $table->string('home_no')->nullable();
            $table->string('name_school')->nullable();
            $table->string('last_grade')->nullable();
            $table->string('school_address')->nullable();
            $table->string('school_phone')->nullable();
            $table->string('last_year')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('students');
    }
}
