@extends('layouts.admin')

@section('styles')
@endsection

@section('content')
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="content-page">
    <!-- Start content -->
    <div class="content">
        <div class="container-fluid">
          <div class="row">
              <div class="col-sm-12">
                  <div class="page-title-box">
                      <div class="row align-items-center">
                          <div class="col-md-8">
                              <h4 class="page-title mb-0">Teacher Attendace Logs</h4>
                              <ol class="breadcrumb m-0">
                                  <li class="breadcrumb-item"><a href="#">Teacher Attendace Logs</a></li>
                              </ol>
                          </div>

                      </div>

                  </div>
              </div>
          </div>
          <!-- end row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="mt-0 header-title">Teacher Attendace Logs List</h4>
                            <div class="table-responsive mt-4">
                                <table class="table table-hover mb-0">
                                    <thead>
                                        <tr>
                                            <th scope="col">(#)</th>
                                            <th scope="col">Name</th>
                                            <th scope="col">Activity Type</th>
                                            <th scope="col">Activity Method</th>
                                            <th scope="col">Activity Time / Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      @foreach($teachers as $teacher)
                                      @foreach($teacher->user->activity as $activity)
                                        <tr>

                                            <td>{{$loop->iteration}}</td>
                                            <td>{{$teacher->name}}</td>
                                            <td>{{$activity->activity_type}}</td>
                                            <td>{{$activity->activity_method}}</td>
                                            <td>{{$activity->activity_time}}</td>
                                        </tr>
                                        @endforeach
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end row -->

        </div> <!-- container-fluid -->

    </div> <!-- content -->

    <footer class="footer">
        © 2020 - 2021  The Educators Academy
    </footer>
</div>


<!-- ============================================================== -->
<!-- End Right content here -->
<!-- ============================================================== -->

@endsection

@section('scripts')

@endsection
