<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });
Route::get('/', 'Web\WebController@index')->name('main');
Route::get('/about', 'Web\WebController@about')->name('about');
Route::get('/franchise', 'Web\WebController@franchise')->name('franchise');
Route::get('/fast-track-credit', 'Web\WebController@fastTrackCredit')->name('fastTrackCredit');
Route::get('/summer-school', 'Web\WebController@summerSchool')->name('summerSchool');
Route::get('/tution', 'Web\WebController@tution')->name('tution');
Route::get('/how-to-apply', 'Web\WebController@howToApply')->name('howToApply');
Route::get('/international-student', 'Web\WebController@internationalStudent')->name('internationalStudent');
Route::get('/contact', 'Web\WebController@contact')->name('contact');
Route::get('/faq', 'Web\WebController@faq')->name('faq');
Route::get('/registration/{id}', 'Web\WebController@registration')->name('registration');
Route::get('/grade_detail/{id}', 'Web\WebController@grade_detail')->name('grade_detail');
Route::get('/course_detail/{id}', 'Web\WebController@course_detail')->name('course_detail');
Route::post('/registerStudent', 'Web\WebController@registerStudent')->name('student.registerStudent');
Route::post('/submit_contactus', 'Web\WebController@submit_contactus')->name('submit_contactus');
Auth::routes();
// to verify the role of the users
Route::get('/home', 'HomeController@loginCheck')->name('home');
Route::get('/loginhome', 'HomeController@loginhome')->name('loginhome');
Route::get('/user/logout', 'HomeController@userLogout')->name('user.logout');
Route::get('/user/logoutsystem', 'HomeController@userLogout2')->name('user.logout2');
// admin controllers
Route::middleware('auth')->prefix('admin')->group(function() {
          Route::get('/dashboard', 'Admin\AdminController@dashboard')->name('admin.dashboard');
          Route::get('/grades', 'Admin\AdminController@grades')->name('admin.grades');
          Route::get('/courses', 'Admin\AdminController@courses')->name('admin.courses');
	 	      Route::get('/contactquery', 'Admin\AdminController@contactquery')->name('admin.contactquery');
		      Route::get('/studentdetail/{id}', 'Admin\AdminController@studentdetail')->name('admin.studentdetail');


          Route::post('/addGrade', 'Admin\AdminController@addGrade')->name('admin.addGrade');
          Route::post('/deleteGrade', 'Admin\AdminController@deleteGrade')->name('admin.deleteGrade');

          Route::post('/addCourse', 'Admin\AdminController@addCourse')->name('admin.addCourse');
          Route::get('/newCourse', 'Admin\AdminController@newCourse')->name('admin.newCourse');
          Route::get('/editviewCourse/{id}', 'Admin\AdminController@editviewCourse')->name('admin.editviewCourse');
          Route::post('/editCourse', 'Admin\AdminController@editCourse')->name('admin.editCourse');
          Route::post('/deleteCourse', 'Admin\AdminController@deleteCourse')->name('admin.deleteCourse');

          Route::get('/all_students', 'Admin\StudentController@all_students')->name('admin.all_students');
          Route::get('/fee_students', 'Admin\StudentController@fee_students')->name('admin.fee_students');
          Route::get('/approved_students', 'Admin\StudentController@approved_students')->name('admin.approved_students');
          Route::post('/approvepayment', 'Admin\StudentController@approvepayment')->name('admin.approvepayment');
          Route::get('/delete_contactus/{id}', 'Admin\AdminController@delete_contactus')->name('admin.delete_contactus');

          Route::get('/all_teachers', 'Admin\TeacherController@all_teachers')->name('admin.all_teachers');
          Route::post('/add_teachers', 'Admin\TeacherController@add_teachers')->name('admin.add_teachers');


          Route::post('/add_settings', 'Admin\AdminController@add_settings')->name('admin.add_settings');
          Route::get('/settings', 'Admin\AdminController@settings')->name('admin.settings');
          Route::get('/teacherlogs', 'Admin\AdminController@teacherlogs')->name('admin.teacherlogs');
          Route::get('/studentlogs', 'Admin\AdminController@studentlogs')->name('admin.studentlogs');
});
Route::middleware('auth')->prefix('student')->group(function() {
          Route::get('/dashboard', 'Student\StudentController@dashboard')->name('student.dashboard');
          Route::get('/pendingpayment', 'Student\StudentController@pendingpayment')->name('student.pendingpayment');
          Route::post('/submitPayment', 'Student\StudentController@submitPayment')->name('student.submitPayment');

});
Route::middleware('auth')->prefix('teacher')->group(function() {
        Route::get('/dashboard', 'Teacher\TeacherController@dashboard')->name('teacher.dashboard');
});
