<?php
namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Modals\Grade;
use App\Modals\Course;
use App\Modals\Student;
use App\Modals\Teacher;
use App\Modals\Registration;
use Session;
use Hash;
use Auth;
use App\User;


class TeacherController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
         $this->middleware('auth');
         $this->middleware('adminuser');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function all_teachers()
    {
      $teachers = Teacher::all();
        return view('admin.all_teachers', ['teachers'=>$teachers]);
    }

    public function add_teachers(Request $request)
    {

      $teachers = new Teacher();
      $teachers->name = $request->name;
      $teachers->gender = $request->gender;
      $teachers->save();

      $user = new User();
      $user->name = $request->name;
      $user->email = $request->email;
      $user->password = Hash::make($request->password);
      $user->teacher_id = $teachers->id;
      $user->save();
      $user->assignRole('Teacher');

        return redirect()->back();
    }



}
