@extends('layouts.admin')

@section('styles')
@endsection

@section('content')
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="content-page">
    <!-- Start content -->
    <div class="content">
        <div class="container-fluid">
          <div class="row">
              <div class="col-sm-12">
                  <div class="page-title-box">
                      <div class="row align-items-center">
                          <div class="col-md-8">
                              <h4 class="page-title mb-0">Students</h4>
                              <ol class="breadcrumb m-0">
                                  <li class="breadcrumb-item"><a href="#">Registrations</a></li>
                                  <li class="breadcrumb-item active" aria-current="page">Pending Approval Students</li>
                              </ol>
                          </div>
                          <div class="col-md-4">
                              <div class="float-right d-none d-md-block">
                                  <div class="dropdown">
                                      <!-- <button class="btn btn-success btn-rounded" type="button"  data-toggle="modal" data-target="#addGradeModal">
                                          <i class="fa fa-plus"></i> Add New Grade
                                      </button> -->

                                  </div>
                              </div>
                          </div>
                      </div>

                  </div>
              </div>
          </div>
          <!-- end row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="mt-0 header-title">All Students List</h4>
                            <div class="table-responsive mt-4">
                                <table class="table table-hover mb-0">
                                    <thead>
                                        <tr>
                                            <th scope="col">(#)</th>
                                            <th scope="col">Name</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Grade</th>
                                            <th scope="col">Course</th>
                                            <th scope="col">Status</th>
                                            <th scope="col" colspan="2">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      @foreach($students as $student)
                                        <tr>
                                            <th scope="row">{{$loop->iteration}}</th>
                                            <td>{{$student->student->given_name}}</td>

                                            <td>{{$student->student->user->email}}</td>
                                            <td>{{$student->grade->name}}</td>
                                            <td>{{$student->course->name}}</td>
                                            <td>@if($student->status == 0)
                                              <span class="label label-danger">Payment Pending</span>
                                              @else
                                              Payment paid
                                              @endif
                                            </td>
                                            <td>
                                                <div>
                                                    <a onclick="setregid({{$student->id}})" data-toggle="modal" data-target="#approveModal" class="btn btn-success btn-sm"><i class="fa fa-check" ></i>Approve</a>
                                                    <a href="#" class="btn btn-primary btn-sm"><i class="fa fa-eye"></i>Details</a>
                                                </div>
                                            </td>
                                        </tr>
                                      @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end row -->

        </div> <!-- container-fluid -->

    </div> <!-- content -->

    <footer class="footer">
        © 2020 - 2021  The Educators Academy
    </footer>
</div>

<div id="approveModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title mt-0" id="myModalLabel">Approve Registration / Student / Paymeny</h5>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
              <form action="{{ route('admin.approvepayment')}}" method="post">
                <div class="row">

<h4>Are you sure you want to approve this Registration ?</h4>
<input type="hidden" name="reg_id" required id="reg_id"/>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary waves-effect" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary waves-effect waves-light" >Approve</button>
            </div>
            {{ csrf_field()}}
            </form>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- ============================================================== -->
<!-- End Right content here -->
<!-- ============================================================== -->

@endsection

@section('scripts')
<script>
function setregid(id)
{
  $("#reg_id").val(id);
}
</script>
@endsection
