<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Modals\Menu;
use App\Modals\Product;
use App\Modals\Image;
use Session;
use Hash;
use Auth;
use Storage;

class AdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
         $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function dashboard()
    {

        return view('admin.dashboard' );
    }
    public function menu()
    {
        return view('admin.menu');
    }
    public function products()
    {
        $menus = Menu::all();
        $products = Product::all();
        return view('admin.products' , ['menus'=>$menus,'products'=>$products]);
    }


    public function addProduct(Request $request)
    {
        $product = new Product();
        $product->name = $request->name;
        $product->description = $request->description;
        $product->size = $request->size;
        $product->price = $request->price;
        $product->additional = $request->addtional;
        $product->menu_id = $request->menu_id;
        $product->save();


        foreach($request->img as $i)
        {

          $namefile = uniqid().".".$i->getClientOriginalExtension();
           $i->storeAs('files', $namefile , 'public');
          // Storage::disk('local')->put('files'.'/'.$namefile, $i, 'public');

        $image = new Image();
        $image->product_id = $product->id;
        $image->name = $namefile;
        $image->save();
        }
        return redirect()->back();
    }
}
