<?php

namespace App\Http\Controllers\Web;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Modals\Menu;
use App\Modals\Product;
use Session;
use Hash;
use Auth;

class WebController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $menus = Menu::all();
        $products = Product::all();

        return view('web.index' , ['menus'=> $menus , 'products'=>$products]);
    }

    public function contact()
    {
        $menus = Menu::all();
        $products = Product::all();

        return view('web.contact' , ['menus'=> $menus , 'products'=>$products]);
    }

    public function product($id)
    {

        $menus = Menu::all();
          $product = Product::where('id', $id)->first();
          if(!isset($product))

          {
            return redirect()->route('main');
          }

        return view('web.product' , ['menus'=> $menus , 'product'=>$product]);
    }

    public function item($id)
    {

        $menus = Menu::all();
          $product = Product::where('menu_id', $id)->get();
          if(!isset($product))

          {
            return redirect()->route('main');
          }

        return view('web.item' , ['menus'=> $menus , 'products'=>$product]);
    }


}
