@extends('layouts.main')

@section('styles')
<style>
.mySlides {display: none;}
/* Slideshow container */
.slideshow-container {
  max-width: 1000px;
  position: relative;
  margin: auto;
}


/* Number text (1/3 etc) */
.numbertext {
  color: #f2f2f2;
  font-size: 12px;
  padding: 8px 12px;
  position: absolute;
  top: 0;
}

/* The dots/bullets/indicators */
.dot {
  height: 15px;
  width: 15px;
  margin: 0 2px;
  background-color: #bbb;
  border-radius: 50%;
  display: inline-block;
  transition: background-color 0.6s ease;
}

/* .active {
  background-color: #717171;
} */

/* Fading animation */
.fade {
  -webkit-animation-name: fade;
  -webkit-animation-duration: 3.5s;
  animation-name: fade;
  animation-duration: 3.5s;
}

@-webkit-keyframes fade {
  from {opacity: .4}
  to {opacity: 1}
}

@keyframes fade {
  from {opacity: .4}
  to {opacity: 1}
}

/* On smaller screens, decrease text size */
@media only screen and (max-width: 300px) {
  .text {font-size: 11px}
}
</style>
@endsection

@section('content')
@include('includes.header')
	<!-- Hero section -->
	<section class="hero-section set-bg" data-setbg="{{ asset('assets/img/cc.jpg') }}" style="background-size: cover;">
		<div class="hero-slider owl-carousel">
			<div class="hs-item">
				<div class="hs-left"><img src="{{ asset('assets/img/hh.png') }}" alt=""></div>
				<div class="hs-right">
					<div class="hs-content">
						<div class="price"></div>
						<h3 style="color: #fff;font-size:30px;"><span style="font-size: 50px;color: #fff">Shepherd-Le</span> <br>Leather Products</h3>
						<a href="#items" class="site-btn">Explore NOW!</a>
					</div>
				</div>
			</div>
			<div class="hs-item">
				<div class="hs-left"><img src="{{ asset('assets/img/122.png') }}" alt=""></div>
				<div class="hs-right">
					<div class="hs-content">
						<div class="price"></div>
							<h3 style="color: #fff;font-size:30px;"><span style="font-size: 50px;color: #fff">Shepherd-Le</span> <br>Leather Products</h3>
						<a href="#items" class="site-btn">Explore NOW!</a>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Hero section end -->


	<!-- Intro section -->

	<!-- Intro section end -->


	<!-- Featured section -->
	<div class="featured-section spad">
		<div class="container">
			<div class="row">
				<div class="col-md-6">
					<div class="featured-item">
						<div class="slideshow-container">

						<div class="mySlides fade">
						  <img src="{{ asset('assets/img/12.jpg') }}" style="width:100%;height: 300px;">
						</div>

						<div class="mySlides fade">

						  <img src="{{ asset('assets/img/7.jpg') }}" style="width:100%;height: 300px;">

						</div>

						<div class="mySlides fade">
						  <img src="{{ asset('assets/img/1bg.jpg') }}" style="width:100%;height: 300px;">
						</div>

						</div>
						<!-- <img src="{{ asset('assets/img/7.jpg') }}" alt="" style="height: 300px;"> -->
						<a href="#items" class="site-btn">Leather Products</a>
					</div>
				</div>
				<div class="col-md-6">
					<div class="featured-item mb-0">
						<div class="slideshow-container">

						<div class="mySlides2 fade">
						  <img src="{{ asset('assets/img/p10.jpg') }}" style="width:100%;height: 300px;">
						</div>

						<div class="mySlides2 fade">

						  <img src="{{ asset('assets/img/i6.jpg') }}" style="width:100%;height: 300px;">

						</div>

						<div class="mySlides2 fade">
						  <img src="{{ asset('assets/img/p10.jpg') }}" style="width:100%;height: 300px;">
						</div>

						</div>
						<!-- <img src="{{ asset('assets/img/i1.jpg') }}" alt="" style="height: 300px;"> -->
						<a href="#nerozi" class="site-btn">Norozi Products</a>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- Featured section end -->


	<!-- Product section -->
	<section class="product-section spad" id="items" style="background: #b09d8142;">
		<div class="container">
			<ul class="product-filter controls">
				<li class="control" data-filter=".male">Male</li>
				<li class="control" data-filter=".female">Female</li>
			</ul>
			<div class="row" id="product-filter">

				@foreach($products->where('menu_id' , '!=' , 8) as $product)
				<div class="mix col-lg-3 col-md-6 {{$product->menu->type}}" >
					<div class="product-item" style="padding: 10px;
	    box-shadow: 0px 3px 9px 0px #888888b8;
	    background: white;">
						<figure>
							<img src="{{ asset ('storage/files/'.$product->pic($product->id))}}" alt="" style="height: 200px;">
							<div class="pi-meta">
								<div class="pi-m-left">
									<p>{{$product->name}}</p>
								</div>

							</div>
						</figure>
						<div class="product-info">
              <h6>{{$product->name}}</h6>
              <!-- <p>$32.20 <span>RRP 64.40</span></p> -->
              <a href="{{ route('product' , $product->id)}}" class="site-btn btn-line">View Details</a>
						</div>
					</div>
				</div>
				@endforeach

			</div>
		</div>
	</section>
	<!-- Product section end -->


	<!-- Blog section -->
	<section class="blog-section spad" id="nerozi">
		<div class="container">
			<div class="row">
				<div class="col-lg-5">
					<div class="featured-item">
						<img src="{{ asset('assets/img/p5.jpg') }}" alt="">
						<!-- <a href="#" class="site-btn">see more</a> -->
					</div>
				</div>
				<div class="col-lg-7">
					<h4 class="bgs-title">from the collection of NOROZI</h4>
					@foreach($products->where('menu_id', 8) as $product1)
					<div class="blog-item">
						<div class="bi-thumb">
							<img src="{{ asset ('storage/files/'.$product1->pic($product1->id))}}" alt="">
						</div>
						<div class="bi-content">
							<h5>{{$product1->name}}</h5>
							<!-- <div class="bi-meta">July 02, 2018   |   By maria deloreen</div> -->
							<a href="#" class="readmore">View Details</a>
						</div>
					</div>
					@endforeach

				</div>
			</div>
		</div>
	</section>
	<!-- Blog section end -->


	<!-- Footer top section -->
	<section class="footer-top-section home-footer">
		<div class="container">
			<div class="row">
				<div class="col-lg-4 col-md-4 col-sm-4">
					<div class="footer-widget about-widget">
						<img src="{{ asset('assets/logo2.png') }}" class="footer-logo" alt="" style="width:30%;">
						<p>House of superior quality leather products.</p>
						<div class="cards">
							<a href=""> <i class="fa fa-facebook"></i></a>
							<a href=""> <i class="fa fa-twitter"></i></a>
							<a href=""> <i class="fa fa-instagram"></i></a>
						</div>
					</div>
				</div>
				<!-- <div class="col-lg-2 col-md-4 col-sm-6">
					<div class="footer-widget">
						<h6 class="fw-title">usefull Links</h6>
						<ul>
							<li><a href="#">Partners</a></li>
							<li><a href="#">Bloggers</a></li>
							<li><a href="#">Support</a></li>
							<li><a href="#">Terms of Use</a></li>
							<li><a href="#">Press</a></li>
						</ul>
					</div>
				</div> -->
				<!-- <div class="col-lg-2 col-md-4 col-sm-6">
					<div class="footer-widget">
						<h6 class="fw-title">Sitemap</h6>
						<ul>
							<li><a href="#">Partners</a></li>
							<li><a href="#">Bloggers</a></li>
							<li><a href="#">Support</a></li>
							<li><a href="#">Terms of Use</a></li>
							<li><a href="#">Press</a></li>
						</ul>
					</div>
				</div> -->
				<!-- <div class="col-lg-2 col-md-4 col-sm-6">
					<div class="footer-widget">
						<h6 class="fw-title">Shipping & returns</h6>
						<ul>
							<li><a href="#">About Us</a></li>
							<li><a href="#">Track Orders</a></li>
							<li><a href="#">Returns</a></li>
							<li><a href="#">Jobs</a></li>
							<li><a href="#">Shipping</a></li>
							<li><a href="#">Blog</a></li>
						</ul>
					</div>
				</div> -->
				<div class="col-lg-8 col-md-8 col-sm-8">
					<div class="footer-widget">
						<h6 class="fw-title">Get In touch with us :)</h6>
						<div class="text-box">
							<p>Muhammad Amer Javed - Shepherd-Le </p>
							<p>Office #11, 2nd Floor (7-Q)Jamal Plaza, Behind Maroof Hospital F-10 Markaz, Islamabad, Pakistan </p>
							<p>+92 301 55537 44</p>
							<p>amer@shepherd-le.com</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- Footer top section end -->


@endsection

@section('scripts')
<script>
var slideIndex = 0;
var slideIndex2 = 0;
showSlides();
showSlides2();

function showSlides() {
  var i;
  var slides = document.getElementsByClassName("mySlides");
  for (i = 0; i < slides.length; i++) {
    slides[i].style.display = "none";
  }
  slideIndex++;
  if (slideIndex > slides.length) {slideIndex = 1}
  slides[slideIndex-1].style.display = "block";
  setTimeout(showSlides, 4000); // Change image every 2 seconds
}

function showSlides2() {
  var i;
  var slides2 = document.getElementsByClassName("mySlides2");
  for (i = 0; i < slides2.length; i++) {
    slides2[i].style.display = "none";
  }
  slideIndex2++;
  if (slideIndex2 > slides2.length) {slideIndex2 = 1}
  slides2[slideIndex2-1].style.display = "block";
  setTimeout(showSlides2, 4000); // Change image every 2 seconds
}
</script>
@endsection
