<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });
Route::get('/', 'Web\WebController@index')->name('main');
Route::get('product/{id}', 'Web\WebController@product')->name('product');
Route::get('item/{id}', 'Web\WebController@item')->name('item');
Route::get('contact', 'Web\WebController@contact')->name('contact');


Auth::routes();
// to verify the role of the users
Route::get('/home', 'HomeController@loginCheck')->name('home');
Route::get('/user/logout', 'HomeController@userLogout')->name('user.logout');
// admin controllers
Route::middleware('auth')->prefix('admin')->group(function() {
          Route::get('/dashboard', 'Admin\AdminController@dashboard')->name('admin.dashboard');
          Route::get('/menu', 'Admin\AdminController@menu')->name('admin.menu');
          Route::get('/products', 'Admin\AdminController@products')->name('admin.products');
          Route::Post('/addProduct', 'Admin\AdminController@addProduct')->name('admin.addProduct');
          Route::Post('/deleteProduct', 'Admin\AdminController@deleteProduct')->name('admin.deleteProduct');
});
